package yangtz.cs.liu.campus.domain.schoolEquipment;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * 设备领用对象 school_receive
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolReceive extends OurBaseEntity
{

    /** 设备id */
    private Long equipmentId;

    /** 领用日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date recipientTime;

    /** 领用人id */
    private Long recipientById;

    /** 领用人 */
    private String recipientBy;

    /** 退还状态(0=未退还，1=已退还)" */
    private String returnState;

    /** 退还日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date returnTime;

    /** 退还时设备情况 */
    private String returnEquipmentCondition;

    /** 接收人id */
    private Long receivedById;

    /** 接收人 */
    private String receivedBy;

    /** 预计使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date yjuseTime;

    /** 实际使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date sjuseTime;

    /** 备注 */
    private String remark;

}
