package yangtz.cs.liu.campus.domain.schoolDepartmentBudget;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 科室预算填报项目明细对象 school_department_budget_projectmx
 *
 * @author ruoyi
 * @date 2023-07-11
 */
public class SchoolDepartmentBudgetProjectmx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 科室预算填报明细主键id */
    private Long id;

    /** 年度 */
    @Excel(name = "年度")
    private String year;

    /** 科室id */
    private Long deptId;

    /** 科室名称 */
    @Excel(name = "科室")
    private String deptName;

    /** 科室预算填报id */
    private Long departmentBudgetId;

    /** 项目名称 */
    @Excel(name = "项目名称")
    private String projectName;

    /** 申报政策依据、理由及主要内容 */
    @Excel(name = "申报政策依据、理由及主要内容")
    private String content;

    /** 项目支出明细 */
    @Excel(name = "项目明细")
    private String projectExpenditures;

    /** 申请总额 */
    @Excel(name = "申请总额")
    private BigDecimal applyMoney;

    /** 单位 */
    @Excel(name = "单位")
    private String unit;

    /** 是否政府采购（1-是，0-否） */
    @Excel(name = "是否政府采购")
    private String isGovernmentPurchase;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 填报人id */
    private Long informantId;

    /** 填报人名称 */
    private String informant;

    /** 分管领导id */
    private Long leadershipId;

    /** 分管领导名称 */
    private String leadershipName;

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getInformantId() {
        return informantId;
    }

    public void setInformantId(Long informantId) {
        this.informantId = informantId;
    }

    public String getInformant() {
        return informant;
    }

    public void setInformant(String informant) {
        this.informant = informant;
    }

    public Long getLeadershipId() {
        return leadershipId;
    }

    public void setLeadershipId(Long leadershipId) {
        this.leadershipId = leadershipId;
    }

    public String getLeadershipName() {
        return leadershipName;
    }

    public void setLeadershipName(String leadershipName) {
        this.leadershipName = leadershipName;
    }

    @Override
    public String getRemark() {
        return remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setDepartmentBudgetId(Long departmentBudgetId)
    {
        this.departmentBudgetId = departmentBudgetId;
    }

    public Long getDepartmentBudgetId()
    {
        return departmentBudgetId;
    }
    public void setProjectName(String projectName)
    {
        this.projectName = projectName;
    }

    public String getProjectName()
    {
        return projectName;
    }
    public void setContent(String content)
    {
        this.content = content;
    }

    public String getContent()
    {
        return content;
    }
    public void setProjectExpenditures(String projectExpenditures)
    {
        this.projectExpenditures = projectExpenditures;
    }

    public String getProjectExpenditures()
    {
        return projectExpenditures;
    }
    public void setIsGovernmentPurchase(String isGovernmentPurchase)
    {
        this.isGovernmentPurchase = isGovernmentPurchase;
    }

    public String getIsGovernmentPurchase()
    {
        return isGovernmentPurchase;
    }
    public void setApplyMoney(BigDecimal applyMoney)
    {
        this.applyMoney = applyMoney;
    }

    public BigDecimal getApplyMoney()
    {
        return applyMoney;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("departmentBudgetId", getDepartmentBudgetId())
                .append("projectName", getProjectName())
                .append("content", getContent())
                .append("projectExpenditures", getProjectExpenditures())
                .append("isGovernmentPurchase", getIsGovernmentPurchase())
                .append("applyMoney", getApplyMoney())
                .append("unit", getUnit())
                .append("remark", getRemark())
                .toString();
    }
}
