package yangtz.cs.liu.campus.domain.schoolAtt;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class SchoolAttEa extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 月度考勤主键 */
    @Excel(name = "月度考勤主键")
    private Long attMonId;

    /** 老师id */
    @Excel(name = "老师id")
    private Long userId;

    /** 老师名称 */
    @Excel(name = "老师名称")
    private String userName;

    /** 职工类型   0 教工  1职工 */
    @Excel(name = "职工类型   0 教工  1职工")
    private String userType;

    /** 请假开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "请假开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 节次1到8 */
    @Excel(name = "节次1到8")
    private String startSort;

    /** 请假结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "请假结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 节次1到8 */
    @Excel(name = "节次1到8")
    private String endSort;

    /** 请假时长 */
    @Excel(name = "请假时长")
    private Double totalTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;
}
