package yangtz.cs.liu.campus.domain.resources;



import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 学校资源库对象 school_resources
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Data
public class SchoolResources extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 资源图片 */
//    @NotBlank(message = "资源图片")
    @Excel(name = "资源图片",cellType = Excel.ColumnType.IMAGE,height = 55)
    private String resourceUrl;

    /** 资源名称 */
    @Excel(name = "资源名称")
    @NotBlank(message = "资源名称不能为空")
    private String name;
}

