package yangtz.cs.liu.campus.domain.recipe;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 学校每日食谱对象 school_recipes
 *
 * @author ruoyi
 * @date 2022-10-05
 */
@Data
public class SchoolRecipes extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

//    /** $column.columnComment */
//    private Long id;

    /** 食谱日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "食谱日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotNull(message = "食谱日期不能为空")
    private Date date;

    /** 早餐 */
    @Excel(name = "早餐")
    @NotBlank(message = "早餐不能为空")
    private String breakfast;

    /** 早点 */
    @Excel(name = "早点")
    private String dessertAfterBreakfast;

    /** 午餐 */
    @NotBlank(message = "午餐不能为空")
    @Excel(name = "午餐")
    private String lunch;

    /** 午点 */
    @Excel(name = "午点")
    private String dessertAfterLunch;

    /** 晚餐 */
    @NotBlank(message = "晚餐不能为空")
    @Excel(name = "晚餐")
    private String dinner;

}
