package yangtz.cs.liu.campus.domain.organization;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 社团活动记录对象 school_organization_activation_record
 * 
 * @author liul
 * @date 2023-09-06
 */
@Data
public class SchoolOrganizationActivationRecord extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 活动主题 */
    @Excel(name = "活动主题")
    private String theme;

    /** 活动开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "活动开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date beginTime;

    /** 活动结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "活动结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 负责人 */
    @Excel(name = "负责人")
    private String fzr;

    /** 社团id */
    @Excel(name = "社团id")
    private Long cid;

    /** 社团名称 */
    @Excel(name = "社团名称")
    private String orgName;

    /** 附件 */
    @Excel(name = "附件")
    private String file;

    /** 备注 */
    private String remark;

}
