package yangtz.cs.liu.campus.domain.office;

import java.math.BigDecimal;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 办公申购对象 school_office_purchase
 *
 * @author xu
 * @date 2022-09-27
 */
@Data
public class SchoolOfficePurchase extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 物品类型 */
    @NotBlank(message = "物品类型不能为空")
    @Excel(name = "物品类型", readConverterExp = "0=教学用品,1=会议用品,2=食堂用品,3=消防用品")
    private String itemType;

    /** 物品名称 */
    @NotBlank(message = "物品名称不能为空")
    @Excel(name = "物品名称")
    private String itemName;

    /** 数量 */
    @NotBlank(message = "数量不能为空")
    @Excel(name = "数量")
    private String numbers;

    /** 价格 */
    @NotNull(message = "价格不能为空")
    @Excel(name = "价格")
    private Float price;

    /** 原因 */
    //@NotBlank(message = "原因不能为空")
    @Excel(name = "原因")
    private String reason;

    /** 状态（0通过，1驳回） */
    //@Excel(name = "状态", readConverterExp = "0=通过,1=驳回")
    private String state;

    /** 申请人id */
    //@Excel(name = "申请人id")
    private Long applyId;

    /** 采购人id */
   //@Excel(name = "采购人id")
    private Long purchaseId;

    /** 采购内容 完成情况 */
    //@NotBlank(message = "采购内容 完成情况不能为空")
    @Excel(name = "采购内容 完成情况")
    private String purchaseContent;

    /** 类型 */
    //@Excel(name = "类型")
    private String type;

    /** 流程实例ID */
    //@Excel(name = "流程实例ID")
    private String instanceId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 角色组 */
    private String roleKey;
}
