package yangtz.cs.liu.campus.domain.introduce;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 园区照片对象 school_pic
 */
@EqualsAndHashCode(callSuper = true)
// 全局配置 equalsAndHashCode 的 callSuper 属性为true，这样就不用每个类都要去写了
@Data
public class SchoolPic extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

//    /**  */
//    private Long id;

    /** 相片路径 */
    @NotBlank(message = "相片路径不能为空！")
    @Excel(name = "相片路径",cellType = Excel.ColumnType.IMAGE,height = 75)
    private String picUrl;


    /** 相片名称 */
    @NotBlank(message = "相片名称不能为空！")
    @Excel(name = "相片名称")
    private String picName;

    /** 排序 */
    @Excel(name = "排序")
    private Integer seqencing;

    /** 是否显示 */
    @Excel(name = "是否显示",readConverterExp = "0=不轮播显示,1=轮播显示")
    private String isShow;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
