package yangtz.cs.liu.campus.domain.introduce;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 学校信息对象 school_introduce
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SchoolIntroduce extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;


    // 版本号
    /**  */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 园所类型 */
    @Excel(name = "园所类型")
    private String kindergartenType;

    /** 成立时间 */
    @NotNull(message = "成立时间不能为空！")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "成立时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date timeOfEstablishment;

    /** 学校名称 */
    @NotBlank(message = "学校名称不能为空！")
    @Excel(name = "学校名称")
    private String kindergartenName;

    /** 法人代表 */
    @NotBlank(message = "法人代表不能为空！")
    @Excel(name = "法人代表")
    private String legalRepresentative;

    /** 园所介绍 */
    @Excel(name = "园所介绍")
    private String introduce;

    /** 校训 */
    @Excel(name = "校训")
    private String schoolMotto;

    /** 简介 */
    @Excel(name = "简介")
    private String synopsis;

    /** 学校状态 */
    @Excel(name = "学校状态")
    private String state;

    /** 地址 */
    @NotBlank(message = "地址不能为空！")
    @Excel(name = "地址")
    private String address;

    /** 园徽路径 */
    private String gardenEmblem;

    /** 师资力量 */
    private String teacherResources;


}
