package yangtz.cs.liu.campus.domain.interest;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 兴趣班学生对象 school_interest_classes_child
 * 
 * @author ruoyi
 * @date 2022-10-09
 */
@Data
public class SchoolInterestClassesChild extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 兴趣班id */
    @NotNull(message = "兴趣班id不能为空")
    @Excel(name = "兴趣班id")
    private Long interestClassesId;

    /** 学生id */
    @NotNull(message = "学生id不能为空")
    @Excel(name = "学生id")
    private Long studentId;

    /** 学生姓名 */
    @Excel(name = "学生姓名")
    @NotBlank(message = "学生姓名不能为空")
    private String studentName;

    /** 学生身份证号 */
    @Excel(name = "学生身份证号" , width = 30)
    @NotBlank(message = "学生身份证号不能为空")
    private String idCard;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;
}
