package yangtz.cs.liu.campus.domain.interest;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotNull;

/**
 * 兴趣班考勤信息对象 school_interest_classes_attendance
 * 
 * @author ruoyi
 * @date 2022-10-09
 */
@Data
public class SchoolInterestClassesAttendance extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 兴趣班id */
    /*@NotNull(message = "兴趣班id不能为空")*/
    //@Excel(name = "兴趣班id")
    private Long interestClassesId;

    /** 应到人数 */
    @Excel(name = "应到人数")
    private Long attend;

    /** 实到人数 */
    @Excel(name = "实到人数")
    private Long actual;

    /** 上课日期 */
    @NotNull(message = "上课日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上课日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date time;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
