package yangtz.cs.liu.campus.domain.interest;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 兴趣班对象 school_interest_classes
 * 
 * @author ruoyi
 * @date 2022-10-04
 */
@Data
public class SchoolInterestClasses extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 课程名称
     */
    @NotBlank(message = "课程名称不能为空")
    @Excel(name = "课程名称")
    private String curriculum;

    /**
     * 学费
     */
    @Excel(name = "学费")
    private String tuition;

    /**
     * 学时
     */
    @Excel(name = "学时")
    private String period;

    /**
     * 任课教师ID
     */
    @NotNull(message = "任课教师ID不能为空")
    @Excel(name = "任课教师ID")
    private Long teacherId;

    /**
     * 学年
     */
    @Excel(name = "学年")
    private String years;

    /**
     * 人数
     */
    @Excel(name = "人数")
    private Integer numberOfPeople;

    /**
     * 学期
     */
    @Excel(name = "学期")
    private String semester;

    /**
     * 教师名称
     */
    @Excel(name = "教师名称")
    private String teacherName;

    /**
     * 照片路径
     */
    @Excel(name = "照片路径")
    private String picUrl;

    /**
     * 简介
     */
    @Excel(name = "简介")
    private String synopsis;

}
