package yangtz.cs.liu.campus.domain.examination;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author xuten
 */
@Data
public class SchoolArtExam extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 考试名称
     * */
    private String examName;

    /**
     * 年度
     * */
    private Integer examYear;

    /**
     * 报名截止时间（具体到分钟）
     * */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date deadline;

    /**
     * 考试开始时间
     * */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 考试结束时间
     * */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 测试项目id(可多选，id之间用逗号隔开)
     * */
    private String projectIds;

    /**
     * 考试安排
     * */
    private String examArrange;

    /**
     * 考试注意事项
     * */
    private String notice;

    /**
     * 状态（0=未发布，1=报名阶段（信息审核），2=考场分配，3=成绩发布，4=结束）
     * */
    private String status;

}
