package yangtz.cs.liu.campus.domain.epidemic;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

@Data
public class EpidemicMain extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 活动名称*/
    @NotBlank(message = "活动名称不能为空")
    @Excel(name = "活动名称")
    private String epidemicName;

    /** 选择的问卷范围 角色类别 */
    private String optionScope;

    /** 0未开始，1进行中，2已结束 */
    @NotBlank(message = "状态必须选择")
    @Excel(name = "状态",readConverterExp = "0=未启用,1=已启用,2=已结束")
    private String state;

    /** 答题开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "答题开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 答题结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "答题结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 是否 领导考题  是否 */
    private String isLeaderExam;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
