package yangtz.cs.liu.campus.domain.device;

import java.util.Date;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 设备维修对象 school_device_record
 *
 * @author ruoyi
 * @date 2022-10-16
 */
@Data
public class SchoolDeviceRecord extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备id */
    @NotNull(message ="设备不能为空")
    private Long deviceId;

    /** 故障描述 */
    @Excel(name = "故障描述")
    private String faultDescription;

    /** 报修类型 */
    @Excel(name = "报修类型", readConverterExp = "0=故障维修,1=设备更换")
    @NotBlank(message ="报修类型不能为空")
    private String repairType;

    /** 提报人 */
    @Excel(name = "提报人")
    private String Informant;

    /** 提报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "提报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportingTime;

    /** 状态 */
    //@Excel(name = "状态")
    private String state;

    /** 流程状态 */
    private Long workflowState;

    /** 维修人 */
    @Excel(name = "维修人")
    private String maintainer;

    /** 维修完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "维修完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date maintenanceCompletionTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 类型 */
    //@Excel(name = "类型")
    private String type;

    /** 流程实例ID */
    //@Excel(name = "流程实例ID")
    private String instanceId;

    /** 申请人 */
   // @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    //@Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    private String roleKey;

}
