package yangtz.cs.liu.campus.controller.thesis;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.thesis.Thesis;
import yangtz.cs.liu.campus.service.thesis.IThesisService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 论文情况Controller
 *
 * @author ruoyi
 * @date 2023-07-24
 */
@RestController
@RequestMapping("/thesis")
public class ThesisController extends BaseController
{
    @Autowired
    private IThesisService thesisService;

    /**
     * 查询论文情况列表
     */
//    @PreAuthorize("@ss.hasPermi('thesis:thesis:list')")
    @GetMapping("/list")
    public TableDataInfo list(Thesis thesis)
    {
        startPage();
        List<Thesis> list = thesisService.selectThesisList(thesis);
        return getDataTable(list);
    }

    /**
     * 导出论文情况列表
     */
//    @PreAuthorize("@ss.hasPermi('thesis:thesis:export')")
    @Log(title = "论文情况", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Thesis thesis)
    {
        List<Thesis> list = thesisService.selectThesisList(thesis);
        ExcelUtil<Thesis> util = new ExcelUtil<Thesis>(Thesis.class);
        util.exportExcel(response, list, "论文情况数据");
    }

    /**
     * 获取论文情况详细信息
     */
//    @PreAuthorize("@ss.hasPermi('thesis:thesis:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(thesisService.selectThesisById(id));
    }

    /**
     * 新增论文情况
     */
//    @PreAuthorize("@ss.hasPermi('thesis:thesis:add')")
    @Log(title = "论文情况", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody Thesis thesis)
    {
        return toAjax(thesisService.insertThesis(thesis));
    }

    /**
     * 修改论文情况
     */
//    @PreAuthorize("@ss.hasPermi('thesis:thesis:edit')")
    @Log(title = "论文情况", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Thesis thesis)
    {
        return toAjax(thesisService.updateThesis(thesis));
    }

    /**
     * 删除论文情况
     */
//    @PreAuthorize("@ss.hasPermi('thesis:thesis:remove')")
    @Log(title = "论文情况", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(thesisService.deleteThesisByIds(ids));
    }
}
