package yangtz.cs.liu.campus.controller.teacher;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAward;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherAwardService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherAwardVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校老师获奖Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/teacherAward")
public class SchoolTeacherAwardController extends BaseController {

    @Autowired
    private ISchoolTeacherAwardService schoolTeacherAwardService;

    /**
     * 查询学校老师获奖列表
     */
//    @PreAuthorize("@ss.hasPermi('school:teacherAward:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherAward schoolTeacherAward) {
        startPage();
        List<SchoolTeacherAward> list = schoolTeacherAwardService.queryList(schoolTeacherAward);
        return getDataTable(list);
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(schoolTeacherAwardService.getById(id));
    }

    /*
     * 新增老师获奖
     * */
//    @PreAuthorize("@ss.hasPermi('school:teacherAward:add')")
    @Log(title = "添加老师获奖信息", businessType = BusinessType.INSERT)
    @PostMapping("/addOne")
    public AjaxResult add(@RequestBody @Validated SchoolTeacherAward schoolTeacherAward) {
        return AjaxResult.success(schoolTeacherAwardService.save(schoolTeacherAward));
//        return AjaxResult.success(schoolTeacherAwardService.insertSchoolTeacherAward(schoolTeacherAward));
    }

    /*
     * 修改老师获奖信息
     * */
//    @PreAuthorize("@ss.hasPermi('school:teacherAward:update')")
    @Log(title = "修改老师信息", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@Validated @RequestBody SchoolTeacherAward schoolTeacherAward) {
        if (StringUtils.isNull(schoolTeacherAward.getId())) {
            AjaxResult.error("老师获奖id未传");
        }
        return AjaxResult.success(schoolTeacherAwardService.updateById(schoolTeacherAward));
//        return AjaxResult.success(schoolTeacherAwardService.updateSchoolTeacherAward(schoolTeacherAward));
    }

    /*
     * 删除老师获奖信息byIdS
     * */
//    @PreAuthorize("@ss.hasPermi('school:teacherAward:update')")
    @Log(title = "修改老师信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/remove/{ids}")
    public AjaxResult delete(@PathVariable List<Long> ids) {
        return toAjax(schoolTeacherAwardService.removeByIds(ids));
//        return AjaxResult.success(schoolTeacherAwardService.deleteSchoolTeacherAwardById(ids));
    }

    /*
     * 删除老师获奖信息byId
     * */
//    @PreAuthorize("@ss.hasPermi('school:teacherAward:update')")
//    @Log(title = "修改老师信息", businessType = BusinessType.DELETE)
//    @PostMapping("/delete/{id}")
//    @Transactional(rollbackFor = Exception.class)
//    public AjaxResult delete(@PathVariable Long id) {
//        return AjaxResult.success(iSchoolTeacherAwardService.deleteSchoolTeacherAwardById(id));
//    }

    /**
     * 按行导出老师获奖信息
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolTeacherAward> list = schoolTeacherAwardService.listByIds(ids);
        ExcelUtil<SchoolTeacherAward> util = new ExcelUtil<>(SchoolTeacherAward.class);
        util.exportExcel(response, list, "老师获奖信息");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param schoolTeacherAward
     */
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolTeacherAward schoolTeacherAward) {
        List<SchoolTeacherAward> list = schoolTeacherAwardService.queryList(schoolTeacherAward);
        ExcelUtil<SchoolTeacherAward> util = new ExcelUtil<>(SchoolTeacherAward.class);
        util.exportExcel(response, list, "老师获奖信息");
    }


}
