package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolStudentClasses;
import yangtz.cs.liu.campus.service.student.ISchoolStudentClassesService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校学生班级Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/studentClasses")
public class SchoolStudentClassesController extends BaseController {

    @Autowired
    private ISchoolStudentClassesService schoolStudentClassesService;

    /**
     * 学生班级列表
     *
     * @param schoolStudentClasses
     * @return
     */
    @GetMapping("/list/{studentId}")
    public TableDataInfo list(SchoolStudentClasses schoolStudentClasses) {
        startPage();
        LambdaQueryWrapper<SchoolStudentClasses> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolStudentClasses::getStudentId, schoolStudentClasses.getStudentId());
        List<SchoolStudentClasses> list = schoolStudentClassesService.list(lqw);
//        List<SchoolStudentClasses> list = schoolStudentClassesService.queryList(schoolStudentClasses);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolStudentClasses
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolStudentClasses schoolStudentClasses) {
        return toAjax(schoolStudentClassesService.save(schoolStudentClasses));
    }

    /**
     * 修改
     *
     * @param schoolStudentClasses
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolStudentClasses schoolStudentClasses) {
        if(StringUtils.isNull(schoolStudentClasses.getId())){
            AjaxResult.error("班级id未传");
        }
        return toAjax(schoolStudentClassesService.updateById(schoolStudentClasses));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolStudentClassesService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolStudentClassesService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolStudentClasses> list = schoolStudentClassesService.listByIds(ids);
        ExcelUtil<SchoolStudentClasses> util = new ExcelUtil<>(SchoolStudentClasses.class);
        util.exportExcel(response, list, "学生班级信息表");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolStudentClasses schoolStudentClasses) {
        LambdaQueryWrapper<SchoolStudentClasses> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolStudentClasses::getCreateTime)
        ;
        List<SchoolStudentClasses> list = schoolStudentClassesService.list(lqw);
        ExcelUtil<SchoolStudentClasses> util = new ExcelUtil<>(SchoolStudentClasses.class);
        util.exportExcel(response, list, "学生班级信息表");
    }
}
