package yangtz.cs.liu.campus.controller.schoolexam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExamDetail;
import yangtz.cs.liu.campus.service.schoolexam.ISchoolExamDetailService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
@RestController
@RequestMapping("/schoolExamDetail")
public class SchoolExamDetailController extends BaseController {
    @Autowired
    private ISchoolExamDetailService schoolExamDetailService;


    /**
     * 查询
     * @param schoolExamDetail
     * @return
     */
    @GetMapping("/list/{examId}")
    public TableDataInfo list(@PathVariable("examId") Long examId, SchoolExamDetail schoolExamDetail){
        schoolExamDetail.setExamId(examId);
        startPage();
        List<SchoolExamDetail> list = schoolExamDetailService.queryList(schoolExamDetail);
        return getDataTable(list);
    }

    /**
     * 添加
     * @param schoolExamDetail
     * @return
     */
    @PostMapping("/add/{examId}")
    public AjaxResult add(@PathVariable("examId") Long examId,@RequestBody @Validated SchoolExamDetail schoolExamDetail){
        schoolExamDetail.setExamId(examId);
        return toAjax(schoolExamDetailService.save(schoolExamDetail));
    }


    /**
     * 删除
     * @param ids
     * @return
     */
    @DeleteMapping("/remove/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids){
        return toAjax(schoolExamDetailService.removeByIds(ids));
    }

    /**
     * 修改
     * @param schoolExamDetail
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult update(@RequestBody @Validated SchoolExamDetail schoolExamDetail){
        return toAjax(schoolExamDetailService.updateById(schoolExamDetail));
    }

    /**
     * 查询详细
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id){
        return AjaxResult.success(schoolExamDetailService.getById(id));
    }


    /**
     * 下载模板
     * @return
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response){
        ExcelUtil<SchoolExamDetail> util = new ExcelUtil<>(SchoolExamDetail.class);
        util.importTemplateExcel(response,"学生成绩表");
    }


    /**
     * 导入
     * @param file
     * @param examId
     * @return
     * @throws Exception
     */
    @PostMapping("/importData/{examId}")
    @ResponseBody
    public AjaxResult importData(MultipartFile file, @PathVariable("examId") Long examId) throws Exception {
        ExcelUtil<SchoolExamDetail> util = new ExcelUtil<SchoolExamDetail>(SchoolExamDetail.class);
        List<SchoolExamDetail> list = util.importExcel(file.getInputStream());
        //校验
        schoolExamDetailService.check(list,examId);
        //导入
        String message = schoolExamDetailService.importExamDetail(list,examId);
        return AjaxResult.success(message);
    }




    /**
     * 导出
     * @param response
     * @param ids
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids){
        List<SchoolExamDetail> list = schoolExamDetailService.listByIds(ids);
        ExcelUtil<SchoolExamDetail> util = new ExcelUtil<>(SchoolExamDetail.class);
        util.exportExcel(response,list,"学生成绩表");
    }


    /**
     * 导出全部
     * @param response
     * @param schoolExamDetail
     */
    @PostMapping("/exportAll/{examId}")
    public void exportAll(HttpServletResponse response, SchoolExamDetail schoolExamDetail, @PathVariable("examId") Long examId){
        LambdaQueryWrapper<SchoolExamDetail> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolExamDetail::getExamId,examId)
                .like(isNotBlank(schoolExamDetail.getStudentName()),SchoolExamDetail::getStudentName,schoolExamDetail.getStudentName())
                .orderByDesc(SchoolExamDetail::getStudentName);
        List<SchoolExamDetail> list = schoolExamDetailService.list(lqw);
        ExcelUtil<SchoolExamDetail> util = new ExcelUtil<>(SchoolExamDetail.class);
        util.exportExcel(response,list,"学生成绩表");
    }
}
