package yangtz.cs.liu.campus.controller.schoolcalendar;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.controller.patrol.SchoolPatrolController;
import yangtz.cs.liu.campus.domain.schoolcalendar.SchoolCalendarDetail;
import yangtz.cs.liu.campus.service.schoolcalendar.ISchoolCalendarDetailService;
import yangtz.cs.liu.campus.vo.schoolcalendar.SchoolCalendarDetailVo;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;


@RestController
@RequestMapping("/schoolCalendarDetail")
public class SchoolCalendarDetailController extends BaseController {
    private Logger log = LoggerFactory.getLogger(SchoolPatrolController.class);
    @Autowired
    private ISchoolCalendarDetailService schoolCalendarDetailService;

    /**
     * 查询校历详细条目列表
     */
    @GetMapping("/list/{calendarId}")
    public TableDataInfo list(@PathVariable("calendarId") Long calendarId, SchoolCalendarDetail schoolCalendarDetail) {
        try {
            startPage();
            schoolCalendarDetail.setCalendarId(calendarId);
            List<SchoolCalendarDetailVo> list = schoolCalendarDetailService.selectSchoolCalendarDetailList(schoolCalendarDetail);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("校历管理列表异常");
        }
    }

    /**
     * 查询单个
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        SchoolCalendarDetailVo schoolCalendarDetail = schoolCalendarDetailService.getQueryOne(id);
        return AjaxResult.success(schoolCalendarDetail);
    }

    /**
     * 校历查找
     * @return
     */
    @GetMapping("/select")
    public AjaxResult selectCalendarDetail(SchoolCalendarDetailVo schoolCalendarDetailVo){
        if (StringUtils.isNull(schoolCalendarDetailVo.getCalendarDate())) {
            throw new BaseException("日期不能为空");
        }
        List<SchoolCalendarDetail> list = schoolCalendarDetailService.selectThings(schoolCalendarDetailVo.getCalendarDate());
        return AjaxResult.success(list);
    }

    //获取整年数据
    @GetMapping("/selectAllYear/{calendarDate}")
    public AjaxResult selectAllYear(@PathVariable("calendarDate") Date calendarDate){
        List<SchoolCalendarDetail> list = schoolCalendarDetailService.selectAllYear(calendarDate);
        return AjaxResult.success(list);
    }

    /**
     * 新增校历详细条目列表
     *
     * @param schoolCalendarDetail
     * @return
     */
    @PostMapping("/add/{calendarId}")
    public AjaxResult addSave(@PathVariable("calendarId") Long calendarId, @RequestBody @Validated SchoolCalendarDetail schoolCalendarDetail) {
        schoolCalendarDetail.setCalendarId(calendarId);
        return toAjax(schoolCalendarDetailService.insertSchoolCalendarDetail(schoolCalendarDetail));
    }


    /**
     * 修改校历详细条目列表
     *
     * @param schoolCalendarDetail
     * @return
     */
    @PutMapping("/edit/{calendarId}")
    public AjaxResult editSave(@PathVariable("calendarId") Long calendarId, @RequestBody @Validated SchoolCalendarDetail schoolCalendarDetail) {
        if (StringUtils.isNull(schoolCalendarDetail.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        schoolCalendarDetail.setCalendarId(calendarId);
        return toAjax(schoolCalendarDetailService.updateSchoolCalendarDetail(schoolCalendarDetail));
    }

    /**
     * 删除校历详细条目列表
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/remove/{ids}")
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        try {
            return toAjax(schoolCalendarDetailService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除数据异常");
        }
    }

    /**
     * 导出部分校历详细条目列表
     *
     * @param response
     * @param ids
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolCalendarDetail> list = schoolCalendarDetailService.listByIds(ids);
        ExcelUtil<SchoolCalendarDetail> util = new ExcelUtil<>(SchoolCalendarDetail.class);
        util.exportExcel(response, list, "校历详细条目列表");
    }

    /**
     * 导出全部校历详细条目列表
     *
     * @param response
     * @param schoolCalendarDetail
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolCalendarDetail schoolCalendarDetail) {
        LambdaQueryWrapper<SchoolCalendarDetail> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolCalendarDetail::getStartTime)
        ;
        List<SchoolCalendarDetail> list = schoolCalendarDetailService.list(lqw);
        ExcelUtil<SchoolCalendarDetail> util = new ExcelUtil<>(SchoolCalendarDetail.class);
        util.exportExcel(response, list, "校历详细条目列表");
    }


}
