package yangtz.cs.liu.campus.controller.schoolSecurity;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVideoConsult;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVideoConsultService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultVo;

/**
 * 监控录像调用(内部)Controller
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@RestController
@RequestMapping("/schoolVideoConsult")
public class SchoolVideoConsultController extends BaseController
{

    @Autowired
    private ISchoolVideoConsultService schoolVideoConsultService;

    /**
     * 查询监控录像调用(内部)列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolVideoConsultVo schoolVideoConsultVo)
    {
        startPage();
        List<SchoolVideoConsultVo> list = schoolVideoConsultService.selectSchoolVideoConsultList(schoolVideoConsultVo);
        return getDataTable(list);
    }

    /**
     * 导出监控录像调用(内部)列表
     */
    @Log(title = "监控录像调用(内部)", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolVideoConsultVo schoolVideoConsultVo)
    {
        List<SchoolVideoConsultVo> list = schoolVideoConsultService.selectSchoolVideoConsultList(schoolVideoConsultVo);
        ExcelUtil<SchoolVideoConsultVo> util = new ExcelUtil<SchoolVideoConsultVo>(SchoolVideoConsultVo.class);
        util.exportExcel(response, list, "监控录像调用(内部)数据");
    }

    /**
     * 获取监控录像调用(内部)详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolVideoConsultService.selectSchoolVideoConsultById(id));
    }

    /**
     * 新增监控录像调用(内部)
     */
    @Log(title = "监控录像调用(内部)", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolVideoConsultVo schoolVideoConsultVo)
    {
        return toAjax(schoolVideoConsultService.insertSchoolVideoConsult(schoolVideoConsultVo));
    }

    /**
     * 修改监控录像调用(内部)
     */
    @Log(title = "监控录像调用(内部)", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolVideoConsultVo schoolVideoConsultVo)
    {
        return toAjax(schoolVideoConsultService.updateSchoolVideoConsult(schoolVideoConsultVo));
    }

    /**
     * 删除监控录像调用(内部)
     */
    @Log(title = "监控录像调用(内部)", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolVideoConsultService.deleteSchoolVideoConsultByIds(ids));
    }
}
