package yangtz.cs.liu.campus.controller.schoolSecurity;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleRegistration;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVehicleRegistrationService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 车辆登记Controller
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@RestController
@RequestMapping("/schoolVehicleRegistration/schoolVehicleRegistration")
public class SchoolVehicleRegistrationController extends BaseController
{

    @Autowired
    private ISchoolVehicleRegistrationService schoolVehicleRegistrationService;

    /**
     * 查询车辆登记列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolVehicleRegistration schoolVehicleRegistration)
    {
        startPage();
        List<SchoolVehicleRegistration> list = schoolVehicleRegistrationService.selectSchoolVehicleRegistrationList(schoolVehicleRegistration);
        return getDataTable(list);
    }

    /**
     * 导出车辆登记列表
     */
    @Log(title = "车辆登记", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolVehicleRegistration schoolVehicleRegistration)
    {
        List<SchoolVehicleRegistration> list = schoolVehicleRegistrationService.selectSchoolVehicleRegistrationList(schoolVehicleRegistration);
        ExcelUtil<SchoolVehicleRegistration> util = new ExcelUtil<SchoolVehicleRegistration>(SchoolVehicleRegistration.class);
        util.exportExcel(response, list, "车辆登记数据");
    }

    /**
     * 获取车辆登记详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolVehicleRegistrationService.selectSchoolVehicleRegistrationById(id));
    }

    /**
     * 新增车辆登记
     */
    @Log(title = "车辆登记", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolVehicleRegistration schoolVehicleRegistration)
    {
        return toAjax(schoolVehicleRegistrationService.insertSchoolVehicleRegistration(schoolVehicleRegistration));
    }

    /**
     * 修改车辆登记
     */
    @Log(title = "车辆登记", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolVehicleRegistration schoolVehicleRegistration)
    {
        return toAjax(schoolVehicleRegistrationService.updateSchoolVehicleRegistration(schoolVehicleRegistration));
    }

    /**
     * 删除车辆登记
     */
    @Log(title = "车辆登记", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolVehicleRegistrationService.deleteSchoolVehicleRegistrationByIds(ids));
    }
}
