package yangtz.cs.liu.campus.controller.schoolSecurity;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleInOut;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVehicleInOutService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherLeaveService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherService;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVehicleInOutVo;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static yangtz.cs.liu.campus.constant.GradeConstant.SCHOOLLEADER;

/**
 * 车辆出入登记Controller
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@RestController
@RequestMapping("/schoolVehicleInOut")
public class SchoolVehicleInOutController extends BaseController
{

    @Autowired
    private ISchoolVehicleInOutService schoolVehicleInOutService;
    @Autowired
    private ISchoolTeacherLeaveService schoolTeacherLeaveService;
    @Autowired
    private ISchoolTeacherService schoolTeacherService;

    /**
     * 查询车辆出入登记列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        startPage();
        List<SchoolVehicleInOutVo> list = schoolVehicleInOutService.selectSchoolVehicleInOutList(schoolVehicleInOutVo);
        return getDataTable(list);
    }

    /**
     * 导出车辆出入登记列表
     */
    @Log(title = "车辆出入登记", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        List<SchoolVehicleInOutVo> list = schoolVehicleInOutService.selectSchoolVehicleInOutList(schoolVehicleInOutVo);
        ExcelUtil<SchoolVehicleInOutVo> util = new ExcelUtil<SchoolVehicleInOutVo>(SchoolVehicleInOutVo.class);
        util.exportExcel(response, list, "车辆出入登记数据");
    }

    /**
     * 获取车辆出入登记详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolVehicleInOutService.selectSchoolVehicleInOutById(id));
    }

    /**
     * 新增车辆出入登记
     */
    @Log(title = "车辆出入登记", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        return toAjax(schoolVehicleInOutService.insertSchoolVehicleInOutVo(schoolVehicleInOutVo));
    }

    /**
     * 修改车辆出入登记
     */
    @Log(title = "车辆出入登记", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        return toAjax(schoolVehicleInOutService.updateSchoolVehicleInOut(schoolVehicleInOutVo));
    }

    /**
     * 删除车辆出入登记
     */
    @Log(title = "车辆出入登记", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolVehicleInOutService.deleteSchoolVehicleInOutByIds(ids));
    }

    /**
     * 获取当前登录人车辆登记信息
     */
    @GetMapping("/getUserVehicle")
    public AjaxResult getUserVehicle(){
        SysUser user = SecurityUtils.getLoginUser().getUser();
        return AjaxResult.success(schoolVehicleInOutService.getUserVehicle(user.getUserId()));
    }

    /**
     * 获取级部/处室领导
     */
    @GetMapping("/getGradeOrDeptLeader/{applyOrgid}")
    public TableDataInfo getGradeOrDeptLeader(@PathVariable Long applyOrgid, SchoolTeacherVO teacherVO){
        //判断用户是职工还是教工，来确定传过来的id是级部id还是部门id
        String employeeType = getLoginUser().getUser().getEmployeeType();
        return getDataTable(schoolTeacherLeaveService.getLeader(applyOrgid,employeeType,teacherVO));
    }

    /**
     * 获取分管领导
     * */
    @GetMapping("/getSchoolLeader")
    public TableDataInfo getSchoolLeader(SchoolTeacherVO teacher) {
        return getDataTable(schoolTeacherService.getSectionLeader(null,SCHOOLLEADER,teacher));
    }

}
