package yangtz.cs.liu.campus.controller.schoolRewardsPunishments;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScAwards;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScDiscipline;
import yangtz.cs.liu.campus.service.schoolRewardsPunishments.ISchoolScDisciplineService;

/**
 * 学生违纪Controller
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@RestController
@RequestMapping("/school/discipline")
public class SchoolScDisciplineController extends BaseController
{
    @Autowired
    private ISchoolScDisciplineService schoolScDisciplineService;

    /**
     * 查询学生违纪列表(管理员)
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("0");
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
        return getDataTable(list);
    }

    /**
     * 查询学生违纪列表(查看已通过)
     */
    @GetMapping("/listTg")
    public TableDataInfo listTg(SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("2");
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineListTg(schoolScDiscipline);
        return getDataTable(list);
    }

    /**
     * 查询学生违纪列表(个人)
     */
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolScDiscipline schoolScDiscipline)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //管理员返回全部
        if (user.isAdmin()) {
            startPage();
            List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
            return getDataTable(list);
        }
        schoolScDiscipline.setApplyId(SecurityUtils.getUserId());
        startPage();
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
        return getDataTable(list);
    }

    /**
     * 导出学生违纪列表
     */
    @Log(title = "学生违纪", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolScDiscipline schoolScDiscipline)
    {
        List<SchoolScDiscipline> list = schoolScDisciplineService.selectSchoolScDisciplineList(schoolScDiscipline);
        ExcelUtil<SchoolScDiscipline> util = new ExcelUtil<SchoolScDiscipline>(SchoolScDiscipline.class);
        util.exportExcel(response, list, "学生违纪数据");
    }

    /**
     * 获取学生违纪详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolScDisciplineService.selectSchoolScDisciplineById(id));
    }

    /**
     * 新增学生违纪(管理员)
     */
    @Log(title = "学生违纪", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setAuditState("1");
        return toAjax(schoolScDisciplineService.insertSchoolScDiscipline(schoolScDiscipline));
    }

    /**
     * 新增学生违纪(个人)
     */
    @Log(title = "学生违纪", businessType = BusinessType.INSERT)
    @PostMapping("/addGr")
    public AjaxResult addGr(@RequestBody SchoolScDiscipline schoolScDiscipline)
    {
        return toAjax(schoolScDisciplineService.insertSchoolScDiscipline(schoolScDiscipline));
    }

    /**
     * 修改学生违纪
     */
    @Log(title = "学生违纪", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolScDiscipline schoolScDiscipline)
    {
        return toAjax(schoolScDisciplineService.updateSchoolScDiscipline(schoolScDiscipline));
    }

    /**
     * 删除学生违纪
     */
    @Log(title = "学生违纪", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolScDisciplineService.deleteSchoolScDisciplineByIds(ids));
    }

    /**
     * 提交/审核
     */
    @PutMapping("/submit")
    public AjaxResult submit(@RequestBody SchoolScDiscipline schoolScDiscipline)
    {
        return toAjax(schoolScDisciplineService.updateById(schoolScDiscipline));
    }

    /**
     * 获取最新三个年级
     */
    @GetMapping("/getGrade")
    public AjaxResult getGrade(){
        return AjaxResult.success(schoolScDisciplineService.getGrade());
    }

    /**
     * 根据年级获取班级
     */
    @GetMapping("/getClassList")
    public AjaxResult getClassList(Long gradeId){
        return AjaxResult.success(schoolScDisciplineService.getClassList(gradeId));
    }
}
