package yangtz.cs.liu.campus.controller.schoolRewardsPunishments;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScAwards;
import yangtz.cs.liu.campus.service.schoolRewardsPunishments.ISchoolScAwardsService;
import yangtz.cs.liu.campus.vo.schoolRewardsPunishments.SchoolScAwardsVo;

/**
 * 学校获奖Controller
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@RestController
@RequestMapping("/school/awards")
public class SchoolScAwardsController extends BaseController
{
    @Autowired
    private ISchoolScAwardsService schoolScAwardsService;

    /**
     * 查询学校获奖列表(管理员)
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolScAwardsVo schoolScAwardsVo)
    {
        schoolScAwardsVo.setAuditState("0");
        startPage();
        List<SchoolScAwardsVo> list = schoolScAwardsService.selectSchoolScAwardsList(schoolScAwardsVo);
        return getDataTable(list);
    }

    /**
     * 查询学校获奖列表(查看已通过)
     */
    @GetMapping("/listTg")
    public TableDataInfo listTg(SchoolScAwardsVo schoolScAwardsVo)
    {
        schoolScAwardsVo.setAuditState("2");
        startPage();
        List<SchoolScAwardsVo> list = schoolScAwardsService.selectSchoolScAwardsListTg(schoolScAwardsVo);
        return getDataTable(list);
    }

    /**
     * 查询学校获奖列表(个人)
     */
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolScAwardsVo schoolScAwardsVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //管理员查询全部
        if (user.isAdmin()) {
            startPage();
            List<SchoolScAwardsVo> list = schoolScAwardsService.selectSchoolScAwardsList(schoolScAwardsVo);
            return getDataTable(list);
        }
        //用户查看个人列表
        schoolScAwardsVo.setApplyId(user.getUserId());
        startPage();
        List<SchoolScAwardsVo> list = schoolScAwardsService.selectSchoolScAwardsList(schoolScAwardsVo);
        return getDataTable(list);
    }

    /**
     * 导出学校获奖列表
     */
    @Log(title = "学校获奖", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolScAwardsVo schoolScAwardsVo)
    {
        List<SchoolScAwardsVo> list = schoolScAwardsService.selectSchoolScAwardsList(schoolScAwardsVo);
        ExcelUtil<SchoolScAwardsVo> util = new ExcelUtil<SchoolScAwardsVo>(SchoolScAwardsVo.class);
        util.exportExcel(response, list, "学校获奖数据");
    }

    /**
     * 获取学校获奖详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolScAwardsService.selectSchoolScAwardsById(id));
    }

    /**
     * 新增学校获奖(管理员)
     */
    @Log(title = "学校获奖", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolScAwardsVo schoolScAwardsVo)
    {
        schoolScAwardsVo.setAuditState("1");
        return toAjax(schoolScAwardsService.insertSchoolScAwards(schoolScAwardsVo));
    }

    /**
     * 新增学校获奖(个人)
     */
    @Log(title = "学校获奖", businessType = BusinessType.INSERT)
    @PostMapping("/addGr")
    public AjaxResult addGr(@RequestBody SchoolScAwardsVo schoolScAwardsVo)
    {
        return toAjax(schoolScAwardsService.insertSchoolScAwards(schoolScAwardsVo));
    }

    /**
     * 修改学校获奖
     */
    @Log(title = "学校获奖", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolScAwardsVo schoolScAwardsVo)
    {
        return toAjax(schoolScAwardsService.updateSchoolScAwards(schoolScAwardsVo));
    }

    /**
     * 删除学校获奖
     */
    @Log(title = "学校获奖", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolScAwardsService.deleteSchoolScAwardsByIds(ids));
    }

    /**
     * 提交
     */
    @PutMapping("/submit")
    public AjaxResult submit(@RequestBody SchoolScAwards schoolScAwards)
    {
        return toAjax(schoolScAwardsService.submit(schoolScAwards));
    }
}
