package yangtz.cs.liu.campus.controller.schoolLab;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYearRelation;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApply;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApplyLabs;
import yangtz.cs.liu.campus.service.accessory.IAccessoryService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassMentorService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabClassYearService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherExperimentApplyService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.service.schoolLab.ISchoollTeacherExperimentApplyLabsService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;

/**
 * 教师个人实验申请Controller
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@RestController
@RequestMapping("/schoolTeacherExperimentApply")
public class SchoolTeacherExperimentApplyController extends BaseController
{

    @Autowired
    private ISchoolTeacherExperimentApplyService schoolTeacherExperimentApplyService;
    @Autowired
    private ISchoollTeacherExperimentApplyLabsService schoollTeacherExperimentApplyLabsService;
    @Autowired
    private IAccessoryService accessoryService;
    @Autowired
    private ISchoolClassMentorService schoolClassMentorService;
    @Autowired
    ISchoolLabClassYearService schoolLabClassYearService;

    /**
     * 查询教师个人实验申请列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        //管理员返回全部
        if (user.isAdmin()){
            startPage();
            List<SchoolTeacherExperimentApplyVo> list = schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyList(schoolTeacherExperimentApplyVo);
            list.forEach(list1 ->{
                String semester = "";
                if (list1.getSemester().equals("1")){
                    semester = "上学期";
                }else {
                    semester = "下学期";
                }
                list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
                list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
                if (list1.getDeclareState().equals("3")){
                    LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,list1.getId());
                    List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
                    list1.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
                }
                LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(SchoolAccessory::getBusinessId,list1.getId())
                        .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
                List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
                if (schoolAccessories.size() > 0){
                    list1.setSchoolAccessoryList(schoolAccessories);
                }
            });
            return getDataTable(list);
        }
        schoolTeacherExperimentApplyVo.setApplyId(user.getUserId());
        startPage();
        List<SchoolTeacherExperimentApplyVo> list = schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyList(schoolTeacherExperimentApplyVo);
        list.forEach(list1 ->{
            String semester = "";
            if (list1.getSemester().equals("1")){
                semester = "上学期";
            }else {
                semester = "下学期";
            }
            list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
            list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
            if (list1.getDeclareState().equals("3")){
                LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,list1.getId());
                List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
                list1.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
            }
            LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
            wrapper1.eq(SchoolAccessory::getBusinessId,list1.getId())
                    .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
            List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
            if (schoolAccessories.size() > 0){
                list1.setSchoolAccessoryList(schoolAccessories);
            }
        });
        return getDataTable(list);
    }

    /**
     * 获取教师个人实验申请详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo = schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyById(id);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String semester = "";
        if (schoolTeacherExperimentApplyVo.getSemester().equals("1")){
            semester = "上学期";
        }else {
            semester = "下学期";
        }
        schoolTeacherExperimentApplyVo.setSchoolYearSemester(schoolTeacherExperimentApplyVo.getSchoolYear() + semester);
        schoolTeacherExperimentApplyVo.setPlannedTime(format.format(schoolTeacherExperimentApplyVo.getPlannedStartTime()) + "至" + format.format(schoolTeacherExperimentApplyVo.getPlannedEndTime()));
        if (schoolTeacherExperimentApplyVo.getDeclareState().equals("3")){
            LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,id);
            List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
            schoolTeacherExperimentApplyVo.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
        }
        LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(SchoolAccessory::getBusinessId,schoolTeacherExperimentApplyVo.getId())
                .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
        List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
        if (schoolAccessories.size() > 0){
            schoolTeacherExperimentApplyVo.setSchoolAccessoryList(schoolAccessories);
        }
        return AjaxResult.success(schoolTeacherExperimentApplyVo);
    }

    /**
     * 实验室管理-教师个人实验申请-获取教师个人实验申请详细信息
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id)
    {
        SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo = schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyById(id);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String semester = "";
        if (schoolTeacherExperimentApplyVo.getSemester().equals("1")){
            semester = "上学期";
        }else {
            semester = "下学期";
        }
        schoolTeacherExperimentApplyVo.setSchoolYearSemester(schoolTeacherExperimentApplyVo.getSchoolYear() + semester);
        schoolTeacherExperimentApplyVo.setPlannedTime(format.format(schoolTeacherExperimentApplyVo.getPlannedStartTime()) + "至" + format.format(schoolTeacherExperimentApplyVo.getPlannedEndTime()));
        if (schoolTeacherExperimentApplyVo.getDeclareState().equals("3") || schoolTeacherExperimentApplyVo.getDeclareState().equals("2") ){
            LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,id);
            List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
            schoolTeacherExperimentApplyVo.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
        }
        LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
        wrapper1.eq(SchoolAccessory::getBusinessId,schoolTeacherExperimentApplyVo.getId())
                .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
        List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
        if (schoolAccessories.size() > 0){
            schoolTeacherExperimentApplyVo.setSchoolAccessoryList(schoolAccessories);
        }
        return AjaxResult.success(schoolTeacherExperimentApplyVo);
    }

    /**
     * 新增教师个人实验申请
     */
    @Log(title = "教师个人实验申请", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
    {
        return toAjax(schoolTeacherExperimentApplyService.insertSchoolTeacherExperimentApply(schoolTeacherExperimentApplyVo));
    }

    /**
     * 修改教师个人实验申请
     */
    @Log(title = "教师个人实验申请", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
    {
        return toAjax(schoolTeacherExperimentApplyService.updateSchoolTeacherExperimentApply(schoolTeacherExperimentApplyVo));
    }

    /**
     * 删除教师个人实验申请
     */
    @Log(title = "教师个人实验申请", businessType = BusinessType.DELETE)
    @PostMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolTeacherExperimentApplyService.deleteSchoolTeacherExperimentApplyByIds(ids));
    }

    /**
     * 实验室管理-教师个人演示实验审批
     */
    @GetMapping("/getTeacherList")
    public TableDataInfo getTeacherList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo){
        schoolTeacherExperimentApplyVo.setDeclareState("0");
        SysUser user = SecurityUtils.getLoginUser().getUser();
        List<SysRole> roles = user.getRoles();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        //管理员返回全部
        if (user.isAdmin()){
            startPage();
            List<SchoolTeacherExperimentApplyVo> list = schoolTeacherExperimentApplyService.getTeacherList(schoolTeacherExperimentApplyVo);
            list.forEach(list1 ->{
                String semester = "";
                if (list1.getSemester().equals("1")){
                    semester = "上学期";
                }else {
                    semester = "下学期";
                }
                list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
                list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
                LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,list1.getId());
                List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
                list1.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
                LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(SchoolAccessory::getBusinessId,list1.getId())
                        .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
                List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
                if (schoolAccessories.size() > 0){
                    list1.setSchoolAccessoryList(schoolAccessories);
                }
            });
            return getDataTable(list);
        }
        //实验室管理员通道
        List<String> labSubs = new ArrayList<>();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                startPage();
                List<SchoolTeacherExperimentApplyVo> list = schoolTeacherExperimentApplyService.getTeacherList(schoolTeacherExperimentApplyVo);
                list.forEach(list1 -> {
                    String semester = "";
                    if (list1.getSemester().equals("1")){
                        semester = "上学期";
                    }else {
                        semester = "下学期";
                    }
                    list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
                    list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
                    LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,list1.getId());
                    List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
                    list1.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
                    LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
                    wrapper1.eq(SchoolAccessory::getBusinessId,list1.getId())
                            .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
                    List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
                    if (schoolAccessories.size() > 0){
                        list1.setSchoolAccessoryList(schoolAccessories);
                    }
                });
                return getDataTable(list);
            }
            switch (role.getRoleKey()){
                case "phy_lab_admin":
                    labSubs.add("1");
                    break;
                case "che_lab_admin":
                    labSubs.add("2");
                    break;
                case "bio_lab_admin":
                    labSubs.add("3");
                    break;
                default:break;
            }
        }
        if (labSubs.size() > 0 ){
            schoolTeacherExperimentApplyVo.setSubs(labSubs);
        }
        startPage();
        List<SchoolTeacherExperimentApplyVo> list = schoolTeacherExperimentApplyService.getTeacherList(schoolTeacherExperimentApplyVo);
        list.forEach(list1 -> {
            String semester = "";
            if (list1.getSemester().equals("1")){
                semester = "上学期";
            }else {
                semester = "下学期";
            }
            list1.setSchoolYearSemester(list1.getSchoolYear() + semester);
            list1.setPlannedTime(format.format(list1.getPlannedStartTime()) + "至" + format.format(list1.getPlannedEndTime()));
            LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,list1.getId());
            List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
            list1.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
            LambdaQueryWrapper<SchoolAccessory> wrapper1 = new LambdaQueryWrapper<>();
            wrapper1.eq(SchoolAccessory::getBusinessId,list1.getId())
                    .eq(SchoolAccessory::getAccessoryType,"教师个人实验结果附件");
            List<SchoolAccessory> schoolAccessories = accessoryService.list(wrapper1);
            if (schoolAccessories.size() > 0){
                list1.setSchoolAccessoryList(schoolAccessories);
            }
        });
        return getDataTable(list);
    }


    /**
     * 实验室管理-教师个人演示实验审批-分配实验室
     */
    @PostMapping("/teacherExperimentLabs")
    public AjaxResult teacherExperimentLabs(@RequestBody SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo){
        return toAjax(schoolTeacherExperimentApplyService.teacherExperimentLabs(schoolTeacherExperimentApplyVo));
    }

    /**
     * 上传实验结果附件
     */
    @PostMapping("/experimentResult")
    public AjaxResult experimentResult(@RequestBody SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo){
        return toAjax(schoolTeacherExperimentApplyService.experimentResult(schoolTeacherExperimentApplyVo));
    }

    /**
     * 获取当前登录角色学科
     */

    @GetMapping("/getSubject")
    public AjaxResult getSubject(){
        Long userId = SecurityUtils.getUserId();
        List<Map<String,String>> subList = new ArrayList<>();

        //设置级部
        //获取学科
        Map<String, String> map = schoolClassMentorService.selectTeacherGroupMentot(userId);
        if (map != null && null != map.get("courseId") ) {
            String s = map.get("courseId");
            List<String> list = Arrays.asList(s.split(","));
            List<String> myList = list.stream().distinct().collect(Collectors.toList());
            List<String> strings = schoolLabClassYearService.convertMentor(myList);
            for (String date : strings) {
                if (date.equals("1")) {
                    Map<String,String> mapList = new HashMap<>();
                    mapList.put("subName", "物理");
                    mapList.put("sub", "1");
                    subList.add(mapList);
                } else if (date.equals("2")) {
                    Map<String,String> mapList = new HashMap<>();
                    mapList.put("subName", "化学");
                    mapList.put("sub", "2");
                    subList.add(mapList);
                } else if (date.equals("3")) {
                    Map<String,String> mapList = new HashMap<>();
                    mapList.put("subName", "生物");
                    mapList.put("sub", "3");
                    subList.add(mapList);
                }
            }
        }
        return AjaxResult.success(subList);
    }

}
