package yangtz.cs.liu.campus.controller.schoolInstrument;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrument;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentService;

import java.util.List;

/**
 * 仪器管理Controller
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/schoolInstrument")
public class SchoolInstrumentController extends BaseController {

    @Autowired
    private ISchoolInstrumentService schoolInstrumentService;

    /**
     * 查询仪器管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolInstrument schoolInstrument)
    {
        startPage();
        List<SchoolInstrument> list = schoolInstrumentService.selectSchoolInstrumentList(schoolInstrument);
        return getDataTable(list);
    }

    /**
     * 获取仪器管理详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolInstrumentService.selectSchoolInstrumentById(id));
    }

    /**
     * 新增仪器管理
     */
    @Log(title = "仪器管理", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolInstrument schoolInstrument)
    {
        return toAjax(schoolInstrumentService.insertSchoolInstrument(schoolInstrument));
    }

    /**
     * 修改仪器管理
     */
    @Log(title = "仪器管理", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolInstrument schoolInstrument)
    {
        return toAjax(schoolInstrumentService.updateSchoolInstrument(schoolInstrument));
    }

    /**
     * 删除仪器管理
     */
    @Log(title = "仪器管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolInstrumentService.deleteSchoolInstrumentByIds(ids));
    }
}
