package yangtz.cs.liu.campus.controller.schoolAtt;

import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttEa;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttMon;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAttOt;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttMonService;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttOtService;

import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/schoolAttOt")
public class SchoolAttOtController extends BaseController {

    @Autowired
    private ISchoolAttOtService otService;

    @Autowired
    private ISchoolAttMonService monService;

    /**
     * 获取考勤明细-加班详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(otService.getById(id));
    }

    /**
     * 新增考勤明细-加班
     */
    @PostMapping("/add/{attMonId}")
    public AjaxResult add(@RequestBody SchoolAttOt schoolAttOt,@PathVariable Long attMonId)
    {
        if(StringUtils.isNull(schoolAttOt.getTotalTime())){
            throw new ServiceException("加班时长不能为空");
        }
        schoolAttOt.setAttMonId(attMonId);
        otService.save(schoolAttOt);
        SchoolAttMon mon = monService.getById(attMonId);
        Double t = mon.getAttOt() + schoolAttOt.getTotalTime();
        mon.setAttOt(t);
        return toAjax(monService.updateById(mon));
    }

    /**
     * 修改考勤明细-加班
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolAttOt schoolAttOt)
    {
        if(StringUtils.isNull(schoolAttOt.getId())){
            throw new ServiceException("id不能为空");
        }
        if(StringUtils.isNull(schoolAttOt.getTotalTime())){
            throw new ServiceException("加班时长不能为空");
        }
        SchoolAttOt ot = otService.getById(schoolAttOt.getId());
        otService.updateById(schoolAttOt);
        SchoolAttMon mon = monService.getById(schoolAttOt.getAttMonId());
        Double t = mon.getAttOt() - ot.getTotalTime() + schoolAttOt.getTotalTime();
        mon.setAttOt(t);
        return toAjax(monService.updateById(mon));
    }

    /**
     * 删除考勤明细-加班
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        List<SchoolAttOt> ots = otService.listByIds(ids);
        SchoolAttMon mon = monService.getById(ots.get(0).getAttMonId());
        Double t = mon.getAttOt();
        for(SchoolAttOt ot : ots){
            t = t - ot.getTotalTime();
        }
        mon.setAttOt(t);
        monService.updateById(mon);
        return toAjax(otService.removeByIds(ids));
    }


    /**
     * 计算加班时长
     * 传参加班开始&结束时间yyyy-MM-dd HH:mm:ss
     * 传参 userType 职工类型   0 教工  1职工
     * 加班人id为空
     * 非初始化新增，就将当天早加班、晚加班、又或者是教师第4节课什么的加班时间加起来，返回当天总加班时间
     * */

    @GetMapping(value = "/count")
    public AjaxResult count(SchoolAttOt schoolAttOt) throws Exception {
        return AjaxResult.success(otService.count(schoolAttOt));
    }

}
