package yangtz.cs.liu.campus.controller.schoolAssets;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import yangtz.cs.liu.campus.controller.schoolClass.SchoolClassController;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssets;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssetsEnter;
import yangtz.cs.liu.campus.domain.schoolAssetsClaim.SchoolAssetsClaim;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsEnterService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsService;
import yangtz.cs.liu.campus.vo.schoolAssets.AssetsEnterVo;
import yangtz.cs.liu.campus.vo.schoolAssets.AssetsOutVo;
import yangtz.cs.liu.campus.vo.schoolAssets.SchoolAssetsEnterVo;
import yangtz.cs.liu.campus.vo.schoolAssets.SchoolAssetsOutVo;

import java.util.List;


/**
 * 【请填写功能名称】Controller
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@RestController
@RequestMapping("/schoolAssetsEnter")
public class SchoolAssetsEnterController extends BaseController
{
//    private Logger log = LoggerFactory.getLogger(SchoolAssetsEnterController.class);
    @Autowired
    private ISchoolAssetsEnterService schoolAssetsEnterService;
    @Autowired
    private ISchoolAssetsService schoolAssetsService;

    @Autowired
    private ISysUserService userService;

    /**
     * 新增入库
     */
    @PostMapping("/add")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult add(@RequestBody @Validated SchoolAssetsEnter schoolAssetsEnter) {
        schoolAssetsEnterService.save(schoolAssetsEnter);
        //库存数量增加
        return toAjax(schoolAssetsService.addAssets(schoolAssetsEnter.getAssetsId(),schoolAssetsEnter.getEnterNumbers()));
    }

    /**
     * 修改入库
     */
    @PostMapping("/edit")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult edit(@RequestBody @Validated SchoolAssetsEnter schoolAssetsEnter) {
        Integer oldNum = schoolAssetsEnterService.getById(schoolAssetsEnter.getId()).getEnterNumbers(); //原来入库数量
        schoolAssetsEnterService.updateById(schoolAssetsEnter);
        Integer newNum = schoolAssetsEnter.getEnterNumbers(); //新的入库数量
        //库存数量更新
        return toAjax(schoolAssetsService.updateInAssets(schoolAssetsEnter.getAssetsId(),oldNum,newNum));
    }

    /**
     * id查询物品ru库记录
     */
    @GetMapping("/queryInfo/{id}")
    public AjaxResult queryInfo(@PathVariable Long id) {
        AssetsEnterVo vo = new AssetsEnterVo();
        SchoolAssetsEnter enter = schoolAssetsEnterService.getById(id);
        BeanUtils.copyProperties(enter,vo);
        SysUser user = userService.selectUserById(enter.getEnterBy());
        if(StringUtils.isNotNull(user)){
            vo.setEnterByName(user.getUserName());
        }
        return AjaxResult.success(vo);
    }


    /**
     * 删除入库
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        try{
            for(Long id : ids){
                Integer number = schoolAssetsEnterService.getById(id).getEnterNumbers();
                Long assetsId = schoolAssetsEnterService.getById(id).getAssetsId();
                schoolAssetsEnterService.removeById(id); //入库记录删除
                schoolAssetsService.reduceAssets(assetsId,number);  //库存记录减少
            }
            return AjaxResult.success("删除成功");
        }catch (Exception e){
            throw new ServiceException("删除失败");
        }
    }

    /**
     * 查询物品入库记录列表
     */
    @GetMapping("/list/{assetsId}")
    public TableDataInfo list(@PathVariable Long assetsId, SchoolAssetsEnterVo schoolAssetsEnterVo) {
        schoolAssetsEnterVo.setAssetsId(assetsId);
        startPage();
        List<AssetsEnterVo> list = schoolAssetsEnterService.queryList(schoolAssetsEnterVo);
        return getDataTable(list);
    }

}
