package yangtz.cs.liu.campus.controller.resources;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.file.FileUploadUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.config.ServerConfig;
import com.sun.jna.platform.win32.WinDef;
import io.swagger.models.auth.In;
import org.apache.catalina.security.SecurityUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.parameters.P;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.resources.SchoolResources;
import yangtz.cs.liu.campus.domain.resources.SchoolResourcesDetails;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesDetailsService;
import yangtz.cs.liu.campus.service.resources.ISchoolResourcesService;
import yangtz.cs.liu.campus.vo.resource.SchoolResourcesDetailsVo;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Security;
import java.util.List;
import java.util.Map;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@RestController
@RequestMapping("/schoolResourcesDetails")
public class SchoolResourcesDetailsController extends BaseController {
    @Autowired
    private ISchoolResourcesDetailsService schoolResourcesDetailsService;


    /**
     * 查询学校资源库列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolResourcesDetailsVo schoolResourcesDetailsVo) {
        startPage();
//        schoolResourcesDetailsVo.setResourcesId(resourcesId);
        List<SchoolResourcesDetailsVo> list = schoolResourcesDetailsService.queryList(schoolResourcesDetailsVo);
        return getDataTable(list);
    }

    @GetMapping("/updateThumbsUp/{id}")
    public AjaxResult updateThumbsUp(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("thumbs_up = thumbs_up + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }

    @GetMapping("/updateCollection/{id}")
    public AjaxResult updateCollection(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("collection = collection + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }

    @GetMapping("/updateDownload/{id}")
    public AjaxResult updateDownload(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolResourcesDetails> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolResourcesDetails::getId, id).setSql("download = download + 1");
        return toAjax(schoolResourcesDetailsService.update(luw));
    }


    /**
     * 获取学校资源库详细信息
     */

    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolResourcesDetailsService.getById(id));
    }

    /**
     * 新增学校资源库
     */
//    此处实现异步上传，即不由后端帮助前端上传，需要由前端手动调用upload
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolResourcesDetails schoolResourcesDetails) {
        return toAjax(schoolResourcesDetailsService.save(schoolResourcesDetails));
    }

    /**
     * 修改学校资源库
     */

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolResourcesDetails schoolResourcesDetails) {
        return toAjax(schoolResourcesDetailsService.updateById(schoolResourcesDetails));
    }

    /**
     * 删除学校资源库
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolResourcesDetailsService.removeByIds(ids));
    }
}
