package yangtz.cs.liu.campus.controller.repairs;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.utils.DateUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.repairs.LogisticsRepairs;
import yangtz.cs.liu.campus.service.repairs.ILogisticsRepairsService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 后勤报修Controller
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@RestController
@RequestMapping("/repairs")
public class LogisticsRepairsController extends BaseController
{
    @Autowired
    private ILogisticsRepairsService logisticsRepairsService;

    /**
     * 查询个人后勤报修列表
     */
//    @PreAuthorize("@ss.hasPermi('repairs:repairs:list')")
    @GetMapping("/list")
    public TableDataInfo list(LogisticsRepairs logisticsRepairs)
    {
        startPage();
        List<LogisticsRepairs> list = logisticsRepairsService.selectLogisticsRepairsList(logisticsRepairs);
        return getDataTable(list);
    }

    /**
     * 导出后勤报修列表
     */
//    @PreAuthorize("@ss.hasPermi('repairs:repairs:export')")
    @Log(title = "后勤报修", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LogisticsRepairs logisticsRepairs)
    {
        List<LogisticsRepairs> list = logisticsRepairsService.selectLogisticsRepairsList(logisticsRepairs);
        ExcelUtil<LogisticsRepairs> util = new ExcelUtil<LogisticsRepairs>(LogisticsRepairs.class);
        util.exportExcel(response, list, "后勤报修数据");
    }

    /**
     * 获取后勤报修详细信息
     */
//    @PreAuthorize("@ss.hasPermi('repairs:repairs:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(logisticsRepairsService.selectLogisticsRepairsById(id));
    }

    /**
     * 新增后勤报修
     */
//    @PreAuthorize("@ss.hasPermi('repairs:repairs:add')")
    @Log(title = "后勤报修", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody LogisticsRepairs logisticsRepairs)
    {
        return toAjax(logisticsRepairsService.insertLogisticsRepairs(logisticsRepairs));
    }

    /**
     * 修改后勤报修
     */
//    @PreAuthorize("@ss.hasPermi('repairs:repairs:edit')")
    @Log(title = "后勤报修", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LogisticsRepairs logisticsRepairs)
    {
        return toAjax(logisticsRepairsService.updateLogisticsRepairs(logisticsRepairs));
    }

    /**
     * 删除后勤报修
     */
//    @PreAuthorize("@ss.hasPermi('repairs:repairs:remove')")
    @Log(title = "后勤报修", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(logisticsRepairsService.deleteLogisticsRepairsByIds(ids));
    }

    /**
     * 获取报修单号
     * @return
     */
    @GetMapping("/getNumber")
    public AjaxResult getNumber(){
        List<LogisticsRepairs> list = logisticsRepairsService.selectListRepairs(new LogisticsRepairs());
        //获取当前日期
        Date nowDate = DateUtils.getNowDate();
        SimpleDateFormat dateFormat= new SimpleDateFormat("yyyyMMdd");
        String format = dateFormat.format(nowDate);
        String number = format + "000001";
        long newNumber = Long.parseLong(number);
        for (LogisticsRepairs repairs : list) {
            if (newNumber == repairs.getId()){
                newNumber = repairs.getId() + 1;
            }
        }
        Map<String,Long> map = new HashMap<>();
        map.put("id",newNumber);
        return AjaxResult.success(map);
    }

    /**
     * 查看所有后勤报修信息
     * @return
     */
    @GetMapping("/listAll")
    public TableDataInfo listAll(LogisticsRepairs logisticsRepairs){
//        startPage();
        return getDataTable(logisticsRepairsService.selectListAll(logisticsRepairs));
    }
}
