package yangtz.cs.liu.campus.controller.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRule;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRuleDetails;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolRuleDetailsService;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolRuleService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 课堂巡检打分规则 controller
 */
@RestController
@RequestMapping("/schoolPatrolRule")
public class SchoolPatrolRuleController extends BaseController {

    @Autowired
    private ISchoolPatrolRuleService schoolPatrolRuleService;

    private Logger log = LoggerFactory.getLogger(SchoolPatrolRuleController.class);


    /**
     * 课堂巡检打分规则列表
     *
     * @param schoolPatrolRule
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolPatrolRule schoolPatrolRule) {
        try {
            startPage();
            List<SchoolPatrolRule> list = schoolPatrolRuleService.queryList(schoolPatrolRule);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询课堂巡检打分规则列表异常");
        }
    }


    /**
     * 新增
     *
     * @param schoolPatrolRule
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolPatrolRule schoolPatrolRule) {
        return toAjax(schoolPatrolRuleService.save(schoolPatrolRule));
    }

    /**
     * 修改
     *
     * @param schoolPatrolRule
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolPatrolRule schoolPatrolRule) {
        if (StringUtils.isNull(schoolPatrolRule.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        return toAjax(schoolPatrolRuleService.updateById(schoolPatrolRule));
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            LambdaQueryWrapper<SchoolPatrolRuleDetails> lwq = new LambdaQueryWrapper<>();
            lwq.in(SchoolPatrolRuleDetails::getRuleId, ids);
            return toAjax(schoolPatrolRuleService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolPatrolRule> list = schoolPatrolRuleService.listByIds(ids);
        ExcelUtil<SchoolPatrolRule> util = new ExcelUtil<>(SchoolPatrolRule.class);
        util.exportExcel(response, list, "课堂巡检打分规则表");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param schoolPatrolRule
     */
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolPatrolRule schoolPatrolRule) {
        LambdaQueryWrapper<SchoolPatrolRule> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotBlank(schoolPatrolRule.getContentType()), SchoolPatrolRule::getContentType, schoolPatrolRule.getContentType())
                .orderByAsc(SchoolPatrolRule::getSort)
        ;
        List<SchoolPatrolRule> list = schoolPatrolRuleService.list(lqw);
        ExcelUtil<SchoolPatrolRule> util = new ExcelUtil<>(SchoolPatrolRule.class);
        util.exportExcel(response, list, "课堂巡检打分规则表");
    }

}
