package yangtz.cs.liu.campus.controller.organization;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationFc;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationFcService;
import yangtz.cs.liu.campus.vo.organization.Fb2Vo;
import yangtz.cs.liu.campus.vo.organization.StFcVo;

import java.util.Arrays;
import java.util.List;

/**
 * 社团风采Controller
 *
 * @author liul
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/fc")
public class SchoolOrganizationFcController extends BaseController
{
    @Autowired
    private ISchoolOrganizationFcService schoolOrganizationFcService;

    /**
     * 查询社团风采列表
     */
    @GetMapping("/list")
    public TableDataInfo list(StFcVo vo)
    {
        LambdaQueryWrapper<SchoolOrganizationFc> wrapper = Wrappers.lambdaQuery();
        wrapper.like(StringUtils.isNotEmpty(vo.getTheme()),SchoolOrganizationFc::getTheme,vo.getTheme())
                .eq(SchoolOrganizationFc::getCid,vo.getCid())
                .orderByDesc(SchoolOrganizationFc::getCreateTime);
        startPage();
        List<SchoolOrganizationFc> list = schoolOrganizationFcService.list(wrapper);
        return getDataTable(list);
    }

    /**
     * 获取社团风采详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolOrganizationFcService.getById(id));
    }

    /**
     * 新增社团风采
     */
    @Log(title = "社团风采", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolOrganizationFc schoolOrganizationFc)
    {
        //先将file的前缀去掉
        String file = schoolOrganizationFc.getFile();
//        if (file!=null){
//            String str ="";
//            String[] split = file.split(",");
//            for (int i = 0; i < split.length; i++) {
//                String substring = split[i].substring(8, split[i].length());
//                str = str+","+substring;
//            }
//            schoolOrganizationFc.setFile(str.substring(1, str.length()));
//        }

        return toAjax(schoolOrganizationFcService.save(schoolOrganizationFc));
    }

    /**
     * 是否发布
     */
    @PostMapping("/isfb")
    public AjaxResult fb(@RequestBody Fb2Vo vo)
    {
        SchoolOrganizationFc fc = schoolOrganizationFcService.getById(vo.getId());
        String isfb = fc.getIsfb();
        if (StringUtils.equals(isfb,"1")){
            fc.setIsfb("2");
        }else {
            fc.setIsfb("1");
        }
        return toAjax(schoolOrganizationFcService.updateById(fc));
    }

    /**
     * 修改社团风采
     */
    @Log(title = "社团风采", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolOrganizationFc schoolOrganizationFc)
    {
        return toAjax(schoolOrganizationFcService.updateById(schoolOrganizationFc));
    }

    /**
     * 删除社团风采
     */
    @Log(title = "社团风采", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        List<Long> list = Arrays.asList(ids);
        return toAjax(schoolOrganizationFcService.removeByIds(list));
    }
}
