package yangtz.cs.liu.campus.controller.organization;

import java.util.Arrays;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationActivationRecord;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationActivationRecordService;
import yangtz.cs.liu.campus.vo.organization.ActivationRecordVo;

/**
 * 社团活动记录Controller
 * 
 * @author liul
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/record")
public class SchoolOrganizationActivationRecordController extends BaseController
{
    @Autowired
    private ISchoolOrganizationActivationRecordService schoolOrganizationActivationRecordService;

    /**
     * 查询社团活动记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ActivationRecordVo vo)
    {
        LambdaQueryWrapper<SchoolOrganizationActivationRecord> wrapper = Wrappers.lambdaQuery();
        wrapper.like(StringUtils.isNotEmpty(vo.getTheme()),SchoolOrganizationActivationRecord::getTheme,vo.getTheme())
                .eq(SchoolOrganizationActivationRecord::getCid,vo.getCid())
                .orderByDesc(SchoolOrganizationActivationRecord::getCreateTime);
        startPage();
        List<SchoolOrganizationActivationRecord> list = schoolOrganizationActivationRecordService.list(wrapper);
        return getDataTable(list);
    }

    /**
     * 获取社团活动记录详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolOrganizationActivationRecordService.getById(id));
    }

    /**
     * 新增社团活动记录
     */
    @Log(title = "社团活动记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolOrganizationActivationRecord schoolOrganizationActivationRecord)
    {
        return toAjax(schoolOrganizationActivationRecordService.save(schoolOrganizationActivationRecord));
    }

    /**
     * 修改社团活动记录
     */
    @Log(title = "社团活动记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolOrganizationActivationRecord schoolOrganizationActivationRecord)
    {
        return toAjax(schoolOrganizationActivationRecordService.updateById(schoolOrganizationActivationRecord));
    }

    /**
     * 删除社团活动记录
     */
    @Log(title = "社团活动记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        List<Long> list = Arrays.asList(ids);
        return toAjax(schoolOrganizationActivationRecordService.removeByIds(list));
    }
}
