package yangtz.cs.liu.campus.controller.notificationGroup;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.ApiController;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.mapper.SysUserMapper;
import com.ruoyi.system.service.ISysUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.notificationGroup.SchoolNotificationGroup;
import yangtz.cs.liu.campus.domain.notificationGroup.SchoolNotificationUser;
import yangtz.cs.liu.campus.domain.notificationGroup.SchoolNotificationUserVo;
import yangtz.cs.liu.campus.service.notificationGroup.SchoolNotificationGroupService;
import yangtz.cs.liu.campus.service.notificationGroup.SchoolNotificationUserService;

/**
 * 通知组(SchoolNotificationGroup)表控制层
 *
 * @author zxw
 * @since 2023-08-18 11:04:47
 */
@RestController
@RequestMapping("/notification")
public class SchoolNotificationGroupController extends BaseController {
    /**
     * 服务对象
     */
    @Resource
    private SchoolNotificationGroupService schoolNotificationGroupService;

    @Autowired
    SchoolNotificationUserService schoolNotificationUserService;

    @Autowired
    private ISysUserService sysUserService;

    /**
     * 分页查询所有数据
     *
     * @param schoolNotificationGroup 查询实体
     * @return 所有数据
     */
    @GetMapping("/list")
    public TableDataInfo selectAll(SchoolNotificationGroup schoolNotificationGroup) {
        startPage();
        QueryWrapper<SchoolNotificationGroup> schooWrapper = new QueryWrapper<>(
            schoolNotificationGroup);
        schooWrapper.orderByAsc("sort");
        List<SchoolNotificationGroup> list = this.schoolNotificationGroupService.list(schooWrapper);
        return getDataTable(list);
    }


    /**
     * 接收人列表
     * @return
     */
    @GetMapping("/getGroupNameList")
    public AjaxResult getGroupNameList(){
        List<SchoolNotificationGroup> list = schoolNotificationGroupService.list();
        return AjaxResult.success(list);
    }

    /**
     * 根据分组id查询人员信息
     */
    @GetMapping("/getUserList/{notificationId}")
    public AjaxResult selectOne(@PathVariable("notificationId") Long notificationId) {
        LambdaQueryWrapper<SchoolNotificationUser> lqw = new LambdaQueryWrapper<>();
         lqw.eq(SchoolNotificationUser::getNotificationId, notificationId);
        List<SchoolNotificationUser> list = this.schoolNotificationUserService.list(lqw);
        List<SysUser> userList = new ArrayList<>();
        list.stream().forEach(data->{
            SysUser sysUser = sysUserService.selectUserById(data.getUserId());
            userList.add(sysUser);
        });
        return AjaxResult.success(userList);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/selectOne/{id}")
    public AjaxResult selectOne(@PathVariable("id") Serializable id) {
        return AjaxResult.success(this.schoolNotificationGroupService.getById(id));
    }

    /**
     * 新增数据
     *
     * @param schoolNotificationGroup 实体对象
     * @return 新增结果
     */
    @PostMapping("/add")
    public AjaxResult insert(@RequestBody SchoolNotificationGroup schoolNotificationGroup) {
        return AjaxResult.success(this.schoolNotificationGroupService.save(schoolNotificationGroup));
    }

    /**
     * 新增人员
     */
    @PostMapping("/addNotificationUser")
    public AjaxResult addNotificationUser(@RequestBody SchoolNotificationUserVo schoolNotificationUser) {
        List<Long> userId = schoolNotificationUser.getUserId();
        for (Long id : userId) {
            SchoolNotificationUser date = new SchoolNotificationUser();
            date.setNotificationId(schoolNotificationUser.getNotificationId());
            date.setUserId(id);
            SchoolNotificationUser oneNotificationUser = schoolNotificationUserService.getOneNotificationUser(date);
            if (null != oneNotificationUser){
                throw  new RuntimeException("当前用户存在分组中");
            }
            boolean save = this.schoolNotificationUserService.save(date);
        }
        return AjaxResult.success();
    }

    /**
     * 删除人员
     */
    @PutMapping("/delectNotificationUser")
    public AjaxResult delectNotificationUser(@RequestBody SchoolNotificationUserVo schoolNotificationUserVo) {
        List<Long> userId = schoolNotificationUserVo.getUserId();
        for (Long id : userId) {
            SchoolNotificationUser date = new SchoolNotificationUser();
            date.setNotificationId(schoolNotificationUserVo.getNotificationId());
            date.setUserId(id);
            SchoolNotificationUser one = this.schoolNotificationUserService
                .getOneNotificationUser (date);
            schoolNotificationUserService.removeById(one.getId());
        }
        return AjaxResult.success();
    }

    /**
     * 修改数据
     *
     * @param schoolNotificationGroup 实体对象
     * @return 修改结果
     */
    @PutMapping("/update")
    public AjaxResult update(@RequestBody SchoolNotificationGroup schoolNotificationGroup) {
        return AjaxResult.success(this.schoolNotificationGroupService.updateById(schoolNotificationGroup));
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @DeleteMapping("/deletes")
    public AjaxResult delete(@RequestParam("idList") List<Long> idList) {
        for (Long id :idList){
            //1.删除相关人员
            LambdaQueryWrapper<SchoolNotificationUser>  user = new LambdaQueryWrapper<>();
            user.eq(SchoolNotificationUser::getNotificationId,id);
            schoolNotificationUserService.remove(user);
        }
        return AjaxResult.success(this.schoolNotificationGroupService.removeByIds(idList));
    }
}

