package yangtz.cs.liu.campus.controller.interest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClasses;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesService;

/**
 * 兴趣班Controller
 * 
 * @author ruoyi
 * @date 2022-10-04
 */
@RestController
@RequestMapping("/interestClass")
public class SchoolInterestClassesController extends BaseController
{
    @Autowired
    private ISchoolInterestClassesService schoolInterestClassesService;

    /**
     * 查询兴趣班列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolInterestClasses schoolInterestClasses)
    {
        startPage();
        List<SchoolInterestClasses> list = schoolInterestClassesService.queryList(schoolInterestClasses);
        return getDataTable(list);
    }

    /**
     * 获取兴趣班详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolInterestClassesService.getById(id));
    }

    /**
     * 新增兴趣班
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolInterestClasses schoolInterestClasses)
    {
        return toAjax(schoolInterestClassesService.save(schoolInterestClasses));
    }

    /**
     * 修改兴趣班
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolInterestClasses schoolInterestClasses)
    {
        if (StringUtils.isNull(schoolInterestClasses.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolInterestClassesService.updateById(schoolInterestClasses));
    }

    /**
     * 删除兴趣班
     */
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolInterestClassesService.deleteList(ids));
    }

    /**
     * 导出兴趣班列表
     */
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolInterestClasses schoolInterestClasses)
    {
        List<SchoolInterestClasses> list = schoolInterestClassesService.queryList(schoolInterestClasses);
        ExcelUtil<SchoolInterestClasses> util = new ExcelUtil<SchoolInterestClasses>(SchoolInterestClasses.class);
        util.exportExcel(response, list, "兴趣班数据");
    }

    /**
     * 导出
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolInterestClasses> list = schoolInterestClassesService.listByIds(ids);
        ExcelUtil<SchoolInterestClasses> util = new ExcelUtil<>(SchoolInterestClasses.class);
        util.exportExcel(response,list,"兴趣班数据");
    }
}
