package yangtz.cs.liu.campus.controller.exam;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.service.exam.IExamDetailService;
import yangtz.cs.liu.campus.service.exam.IExamMainService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.service.exam.IExamUserService;
import yangtz.cs.liu.campus.vo.exam.ExamDetailVo;
import yangtz.cs.liu.campus.vo.exam.ExamMainVo;

import java.util.List;

/**
 * 参与情况
 */
@RestController
@RequestMapping("/examParticipation")
public class ExamParticipationController extends BaseController {


    @Autowired
    private IExamMainService examMainService;

    @Autowired
    private IExamDetailService examDetailService;

    private Logger log = LoggerFactory.getLogger(ExamParticipationController.class);


    /**
     * 查询参与情况
     *
     * @param exam
     * @return
     */
    @GetMapping("/getExamPeopleNum/{examId}")
    public TableDataInfo getExamPeopleNum(@PathVariable("examId") Long examId, ExamMainVo exam) {
        try {
            exam.setId(examId);
            startPage();
            List<ExamMainVo> list = examMainService.selectTakeExamPeoNumList(exam);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询参与情况出现异常");
        }
    }

    /**
     * 统计结果
     *
     * @param examId
     * @return
     */
    @GetMapping("/getResult")
    public TableDataInfo selectResult(Long examId) {
        startPage();
        List<ExamDetailVo> list = examDetailService.selectResult(examId);
        return getDataTable(list);

    }

}
