package yangtz.cs.liu.campus.controller.exam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.service.exam.IExamDetailService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;

/**
 * 问卷内容
 */
@RestController
@RequestMapping("/examDetail")
public class ExamDetailController extends BaseController {

    @Autowired
    private IExamDetailService examDetailService;

    private Logger log = LoggerFactory.getLogger(ExamDetailController.class);

    /**
     * 获取问卷内容
     *
     * @param examDetail
     * @return
     */
    @GetMapping("/list/{examId}")
    public TableDataInfo list(@PathVariable("examId") Long examId, ExamDetail examDetail) {
        try {
            examDetail.setExamId(examId);
            startPage();
            List<ExamDetail> list = examDetailService.queryList(examDetail);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询问卷内容时出现异常");
        }
    }

    /**
     * 新增
     *
     * @param examDetail
     * @return
     */
    @PostMapping("/add/{examId}")
    public AjaxResult add(@PathVariable("examId") Long examId, @RequestBody @Validated ExamDetail examDetail) {
        examDetail.setExamId(examId);
        return toAjax(examDetailService.save(examDetail));
    }

    /**
     * 修改
     *
     * @param examDetail
     * @return
     */
    @PutMapping("/edit/{examId}")
    public AjaxResult edit(@PathVariable("examId") Long examId, @RequestBody @Validated ExamDetail examDetail) {
        examDetail.setExamId(examId);
        if (StringUtils.isNull(examDetail.getId())) {
            throw new BaseException("主键id不能为空");
        }
        return toAjax(examDetailService.updateById(examDetail));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(examDetailService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            return toAjax(examDetailService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<ExamDetail> list = examDetailService.listByIds(ids);
        ExcelUtil<ExamDetail> util = new ExcelUtil<>(ExamDetail.class);
        util.exportExcel(response, list, "问卷内容");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, ExamDetail examDetail) {
        LambdaQueryWrapper<ExamDetail> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(examDetail.getExamId()), ExamDetail::getExamId, examDetail.getExamId())
                .orderByAsc(ExamDetail::getSort)
        ;
        List<ExamDetail> list = examDetailService.list(lqw);
        ExcelUtil<ExamDetail> util = new ExcelUtil<>(ExamDetail.class);
        util.exportExcel(response, list, "问卷内容");
    }


    /**
     * 下载模板
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<ExamDetail> util = new ExcelUtil<ExamDetail>(ExamDetail.class);
        util.importTemplateExcel(response, "用户数据");
    }


//    /**
//     * 导入数据
//     *
//     * @param detailList 试题信息
//     * @param examId
//     * @return
//     * @throws Exception
//     */
//    @PostMapping("/importData/{examId}")
//    public AjaxResult importData(@RequestParam(required = false) List<ExamDetail> detailList, @PathVariable Long examId) throws Exception {
//        //1.先校验
//        examDetailService.check(detailList, examId);
//        //2.导入
//        String message = examDetailService.importData(detailList, examId);
//        return AjaxResult.success(message);
//    }


    /**
     * 导入数据
     *
     * @param file   文件
     * @param examId
     * @return
     * @throws Exception
     */
    @PostMapping("/importData/{examId}")
    public AjaxResult importData(MultipartFile file, @PathVariable("examId") Long examId) throws Exception {
        ExcelUtil<ExamDetail> util = new ExcelUtil<ExamDetail>(ExamDetail.class);
        List<ExamDetail> detailList = util.importExcel(file.getInputStream());
        //1.先校验
        examDetailService.check(detailList, examId);
        //2.导入
        String message = examDetailService.importData(detailList, examId);
        return AjaxResult.success(message);
    }


}
