package yangtz.cs.liu.campus.controller.epidemic;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserScoreDetaiService;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserScoreService;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreDetailService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.service.exam.IExamUserService;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicUserVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 问卷范围
 */
@RequestMapping("/epidemicUser")
@RestController
public class EpidemicUserController extends BaseController {

    @Autowired
    private IEpidemicUserService epidemicUserService;

    @Autowired
    private IEpidemicUserScoreService epidemicUserScoreService;

    @Autowired
    private IEpidemicUserScoreDetaiService epidemicUserScoreDetailService;

    private Logger log = LoggerFactory.getLogger(EpidemicUserController.class);

    /**
     * 查询范围（成员）列表
     *
     * @param epidemicUser
     * @return
     */
    @GetMapping("/list/{epidemicId}")
    public TableDataInfo list(@PathVariable("epidemicId") Long epidemicId, EpidemicUserVo epidemicUser) {
        try {
            epidemicUser.setEpidemicId(epidemicId);
            startPage();
            List<EpidemicUserVo> list = epidemicUserService.queryList(epidemicUser);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询时出现异常");
        }
    }

//    /**
//     * 新增
//     *
//     * @param examUser
//     * @return
//     */
//    @PostMapping("/add/{examId}")
//    public AjaxResult add(@PathVariable("examId") Long examId, @RequestBody @Validated ExamUser examUser) {
//        examUser.setExamId(examId);
//        return toAjax(examUserService.save(examUser));
//    }

    /**
     * 新增时弹窗
     *
     * @param epidemicUser
     * @return
     */
    @GetMapping("/addList")
    public TableDataInfo addList(EpidemicUserVo epidemicUser) {
        try {
            List<Long> userIdList = epidemicUserService.selectAllUserIdByEpidemicId(epidemicUser.getEpidemicId());
            startPage();
            List<EpidemicUserVo> epidemicUserVoList = epidemicUserService.selectAddList(epidemicUser, userIdList);
            return getDataTable(epidemicUserVoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询失败");
        }
    }


    /**
     * 新增学员,挂载到当前的问卷范围下
     */
    @PostMapping("/add/{epidemicId}/{userIds}")
    public AjaxResult add(@PathVariable Long epidemicId, @PathVariable Long[] userIds) {
        return toAjax(epidemicUserService.addExamUsers(epidemicId, userIds));
    }



    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
//            LambdaQueryWrapper<ExamUserScore> lwq = new LambdaQueryWrapper<>();
//            lwq.in(ExamUserScore::getUserId, ids);
//            examUserScoreService.remove(lwq);
//            List<ExamUserScore> examUserScoreList = examUserScoreService.list(lwq);
//            List<Long> list = new ArrayList<>();
//            for (ExamUserScore examUserScore : examUserScoreList) {
//                list.add(examUserScore.getUserId());
//            }
//            LambdaQueryWrapper<ExamUserScoreDetail> detailLwq = new LambdaQueryWrapper<>();
//            examUserScoreDetaiService.remove(detailLwq);
            return toAjax(epidemicUserService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<EpidemicUserVo> list = epidemicUserService.export(ids);
        ExcelUtil<EpidemicUserVo> util = new ExcelUtil<>(EpidemicUserVo.class);
        util.exportExcel(response, list, "问卷范围");
    }


    /**
     * 导出全部
     *
     * @param response
     * @param epidemicUser
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, EpidemicUserVo epidemicUser) {
        List<EpidemicUserVo> list = epidemicUserService.queryList(epidemicUser);
        ExcelUtil<EpidemicUserVo> util = new ExcelUtil<>(EpidemicUserVo.class);
        util.exportExcel(response, list, "问卷范围");
    }
}
