package yangtz.cs.liu.campus.controller.epidemic;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicDetailService;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicMainService;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserScoreDetaiService;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserScoreService;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicMainVo;
import yangtz.cs.liu.campus.vo.epidemic.IScoreVo;

import java.util.List;

/**
 * 代办任务
 */
@RequestMapping("/epidemicTasks")
@RestController
public class EpidemicTasksController extends BaseController {

    @Autowired
    private IEpidemicMainService epidemicMainService;

    @Autowired
    private IEpidemicUserScoreService epidemicUserScoreService;

    @Autowired
    private IEpidemicUserScoreDetaiService epidemicUserScoreDetailService;

    @Autowired
    private IEpidemicDetailService epidemicDetailService;

    private Logger log = LoggerFactory.getLogger(EpidemicTasksController.class);

    /**
     * 查询代办任务
     *
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list() {
        try {
            startPage();
//        //拿到当前登录用户
//        SysUser user = SecurityUtils.getLoginUser().getUser();
            getUserId();
            EpidemicMainVo epidemicMainVo = new EpidemicMainVo();
            epidemicMainVo.setUserId(getUserId());
            List<EpidemicMainVo> list = epidemicMainService.selectEpidemicTasks(epidemicMainVo);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询代办任务时出现异常");
        }

    }

    /**
     * 参加打分功能
     *
     * @param epidemicId
     * @param score
     * @return
     */
    @PostMapping("/join/{epidemicId}")
    public AjaxResult join(@PathVariable("epidemicId") Long epidemicId, @RequestBody IScoreVo score) {
        try {
            epidemicMainService.join(epidemicId, score);
            return AjaxResult.success("操作成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("参与打分失败!");
        }
    }


}
