package yangtz.cs.liu.campus.controller.epidemic;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicDetailService;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicMainService;
import yangtz.cs.liu.campus.service.exam.IExamDetailService;
import yangtz.cs.liu.campus.service.exam.IExamMainService;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicDetailVo;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicMainVo;
import yangtz.cs.liu.campus.vo.exam.ExamDetailVo;
import yangtz.cs.liu.campus.vo.exam.ExamMainVo;

import java.util.List;

/**
 * 参与情况
 */
@RestController
@RequestMapping("/epidemicParticipation")
public class EpidemicParticipationController extends BaseController {


    @Autowired
    private IEpidemicMainService epidemicMainService;

    @Autowired
    private IEpidemicDetailService epidemicDetailService;

    private Logger log = LoggerFactory.getLogger(EpidemicParticipationController.class);


    /**
     * 查询参与情况
     *
     * @param epidemic
     * @return
     */
    @GetMapping("/getExamPeopleNum/{epidemicId}")
    public TableDataInfo getEpidemicPeopleNum(@PathVariable("epidemicId") Long epidemicId, EpidemicMainVo epidemic) {
        try {
            epidemic.setId(epidemicId);
            startPage();
            List<EpidemicMainVo> list = epidemicMainService.selectTakeEpidemicPeoNumList(epidemic);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询参与情况出现异常");
        }
    }

    /**
     * 统计结果
     *
     * @param epidemicId
     * @return
     */
    @GetMapping("/getResult")
    public TableDataInfo selectResult(Long epidemicId) {
        startPage();
        List<EpidemicDetailVo> list = epidemicDetailService.selectResult(epidemicId);
        return getDataTable(list);

    }

}
