package yangtz.cs.liu.campus.controller.device;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.domain.device.SchoolDevice;
import yangtz.cs.liu.campus.service.area.ISchoolAreaService;
import yangtz.cs.liu.campus.service.device.ISchoolDeviceService;
import yangtz.cs.liu.campus.vo.device.DeviceByIdVo;
import yangtz.cs.liu.campus.vo.device.DeviceListVo;

/**
 * 设备管理Controller
 *
 * @author ruoyi
 * @date 2022-10-16
 */
@RestController
@RequestMapping("/device")
public class SchoolDeviceController extends BaseController {
    @Autowired
    private ISchoolDeviceService schoolDeviceService;
    @Autowired
    private ISchoolAreaService schoolAreaService;

    /**
     * 查询设备管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolDevice schoolDevice) {
        startPage();
        List<SchoolDevice> list = schoolDeviceService.queryList(schoolDevice);
        return getDataTable(list);
    }

    /**
     * 新增设备信息
     */
    @ApiOperation("新增")
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolDevice schoolDevice) {
        return toAjax(schoolDeviceService.save(schoolDevice));
    }

    /**
     * 获取设备详细信息
     */
    @ApiOperation("id查询")
    @GetMapping("/queryById/{id}")
    public AjaxResult queryById(@PathVariable("id") Long id) {
        SchoolDevice schoolDevice = schoolDeviceService.queryById(id);
        if (StringUtils.isNull(schoolDevice)) {
            return AjaxResult.error("数据库不存在此条数据");
        }
//        DeviceByIdVo entity = schoolDeviceService.toIdVo(schoolDevice);
        DeviceByIdVo entity = new DeviceByIdVo();
        SchoolArea area = schoolAreaService.getById(schoolDevice.getAreaId());
        if(StringUtils.isNotNull(area)){
            entity.setAreaName(area.getAreaName());
        }
        BeanUtils.copyProperties(schoolDevice, entity);
        return AjaxResult.success(entity);
    }

    @ApiOperation("修改")
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolDevice schoolDevice) {
        if (StringUtils.isNull(schoolDevice.getId())) {
            throw new ServiceException("更新失败,id不能为空");
        }
        return toAjax(schoolDeviceService.updateById(schoolDevice));
    }

    /**
     * 删除设备信息
     */
    @ApiOperation("删除")
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        //级联级删除
        return toAjax(schoolDeviceService.deleteByIds(ids));
    }

    /**
     * 导出设备列表
     */
    @ApiOperation("导出excel")
    @PostMapping("/export/{ids}")
    public void export(@PathVariable List<Long> ids, HttpServletResponse response) throws IOException {
        LambdaQueryWrapper<SchoolDevice> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolDevice::getId,ids).orderByDesc(SchoolDevice::getCreateTime);
        List<SchoolDevice> list = schoolDeviceService.list(lqw);
        ExcelUtil<SchoolDevice> util = new ExcelUtil<>(SchoolDevice.class);
        util.exportExcel(response, list, "设备信息列表");
    }

    /**
     * 导出全部
     */
    @ApiOperation("导出excel")
    @PostMapping("/exportAll")
    public void exportAll(HttpServletResponse response,SchoolDevice schoolDevice) throws IOException {
        List<SchoolDevice> list = schoolDeviceService.queryList(schoolDevice);
        ExcelUtil<SchoolDevice> util = new ExcelUtil<>(SchoolDevice.class);
        util.exportExcel(response, list, "设备信息列表");
    }

}
