package yangtz.cs.liu.campus.controller.SchoolStudentIntegral;


import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.service.ISchoolStudentIntegra.ISchoolStudentIntegralService;
import yangtz.cs.liu.campus.service.impl.student.SchoolStudentServiceImpl;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Scanner;

/**
 * 学生积分Controller
 *
 * @author hxz
 * @date 2023-02-23
 */
@RestController
@RequestMapping("/integral")
public class SchoolStudentIntegralController extends BaseController
{
    @Autowired
    private ISchoolStudentIntegralService schoolStudentIntegralService;
    @Autowired
    SchoolStudentServiceImpl schoolStudentService;


    /**
     * 查询某学生某学年   当前学期（先暂定当前学期） 积分列表
     * 前端传个学年，学生id
     */
    @GetMapping("/list/{studentId}")
    public TableDataInfo list(@PathVariable Long studentId, SchoolStudentIntegral schoolStudentIntegral)
    {
        //获取所在学期
        int term = isNewTerm();
        schoolStudentIntegral.setStudentId(studentId);
        schoolStudentIntegral.setSchoolYear(null);
//        schoolStudentIntegral.setTerm(term);
        startPage();
        List<SchoolStudentIntegral> list = schoolStudentIntegralService.selectSchoolStudentIntegralList(schoolStudentIntegral);
        return getDataTable(list);
    }

    private Integer isNewTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }

    private Integer isNewTermY(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        //获取当前年月
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }

    /**
     * 查询改名学生总积分????
     * @param schoolStudentIntegral
     * @return
     */
    @GetMapping("/allScore")
    public AjaxResult getAllScore(@RequestBody SchoolStudentIntegral schoolStudentIntegral){
       LambdaQueryWrapper<SchoolStudentIntegral> lambdaQueryWrapper=new LambdaQueryWrapper<>();
       lambdaQueryWrapper.eq(SchoolStudentIntegral::getStudentId,schoolStudentIntegral.getStudentId());
       List<SchoolStudentIntegral> list = schoolStudentIntegralService.list(lambdaQueryWrapper);
        double sum=100;
        for (int i = 0; i < list.size(); i++) {
            sum = list.get(i).getScore()+sum;
        }
        return  AjaxResult.success("查询成功",sum);

    }

    /**
     * 导出学生积分列表
     */
   // @PreAuthorize("@ss.hasPermi('system:integral:export')")
    @Log(title = "学生积分", businessType = BusinessType.EXPORT)
    @PostMapping("/export/{studentId}")
    public void export(HttpServletResponse response, @PathVariable Long studentId,SchoolStudentIntegral schoolStudentIntegral)
    {
        schoolStudentIntegral.setStudentId(studentId);
//        schoolStudentIntegral.setTerm(isNewTerm());
        List<SchoolStudentIntegral> list = schoolStudentIntegralService.selectSchoolStudentIntegralList(schoolStudentIntegral);
        ExcelUtil<SchoolStudentIntegral> util = new ExcelUtil<SchoolStudentIntegral>(SchoolStudentIntegral.class);
        util.exportExcel(response, list, "学生积分数据");
    }

    /**
     * 获取学生积分详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable Long id)
    {
        return AjaxResult.success(schoolStudentIntegralService.getById(id));
    }

    /**
     * 新增学生积分
     * 根据日期判断所添加的这个积分应属于哪学年哪学期
     */
  //  @PreAuthorize("@ss.hasPermi('system:integral:add')")
    @Log(title = "学生积分", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolStudentIntegral schoolStudentIntegral)
    {
        if(StringUtils.isNull(schoolStudentIntegral.getDay())){
            throw new ServiceException("日期为空");
        }
        //根据日期判断所添加的这个积分应属于哪学年哪学期
        int schoolYear = DateUtils.getSchoolYear(schoolStudentIntegral.getDay());

        int term = isNewTermY(schoolStudentIntegral.getDay());
        schoolStudentIntegral.setSchoolYear(schoolYear);
        schoolStudentIntegral.setTerm(term);
        //schoolStudentIntegral.setCreateTime(DateTime.now());
        schoolStudentIntegral.insert();
        return toAjax(schoolStudentIntegralService.save(schoolStudentIntegral));
    }

    /**
     * 修改学生积分
     */
    @Log(title = "学生积分", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolStudentIntegral schoolStudentIntegral)
    {
        if(StringUtils.isNull(schoolStudentIntegral.getId())){
            throw new ServiceException("id为空");
        }
        if(StringUtils.isNull(schoolStudentIntegral.getDay())){
            throw new ServiceException("日期为空");
        }
        //根据日期判断所添加的这个积分应属于哪学年哪学期
        int schoolYear = DateUtils.getSchoolYear(schoolStudentIntegral.getDay());
        //int term = DateUtils.getTerm(schoolStudentIntegral.getDay());
        int term = isNewTerm();
        schoolStudentIntegral.setSchoolYear(schoolYear);
        schoolStudentIntegral.setTerm(term);
        schoolStudentIntegral.update();
        return toAjax(schoolStudentIntegralService.updateById(schoolStudentIntegral));
    }

    /**
     * 删除学生积分
     */
    @Log(title = "学生积分", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolStudentIntegralService.deleteSchoolStudentIntegralByIds(ids));
    }


}
