package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolReceive;
import yangtz.cs.liu.campus.service.schoolEquipment.IReceiveService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveVo;

/**
 * 设备领用
 */

@RestController
@RequestMapping("/receive")
public class ReceiveController extends BaseController {

    @Autowired
    private IReceiveService receiveService;

    /**
     * 查看设备领用列表
     * @param schoolReceiveVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolReceiveVo schoolReceiveVo){
        startPage();
        return getDataTable(receiveService.selectSchoolReceiveVoList(schoolReceiveVo));
    }

    /**
     * 查看设备领用详细信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(receiveService.selectSchoolReceiveVoById(id));
    }

    /**
     * 新增设备领用
     * @param schoolReceive
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolReceive schoolReceive){
        return toAjax(receiveService.insertSchoolReceive(schoolReceive));
    }

    /**
     * 修改设备领用
     * @param schoolReceive
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolReceive schoolReceive){
        return toAjax(receiveService.updateSchoolReceive(schoolReceive));
    }

    /**
     * 删除设备领用
     * @param ids
     * @return
     */
    @PostMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids){
        return toAjax(receiveService.deleteSchoolReceiveByIds(ids));
    }
}
