package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolProductCategory;
import yangtz.cs.liu.campus.service.schoolEquipment.IProductCategoryService;

/**
 * 产品分类
 */

@RestController
@RequestMapping("/productCategory")
public class ProductCategoryController extends BaseController {

    @Autowired
    private IProductCategoryService productCategoryService;

    /**
     * 查看产品分类列表
     * @param schoolProductCategory
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolProductCategory schoolProductCategory){
        return getDataTable(productCategoryService.selectSchoolProductCateGory(schoolProductCategory));
    }

    /**
     * 查看产品分类详细信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(productCategoryService.selectSchoolProductCateGoryById(id));
    }

    /**
     * 新增产品分类
     * @param schoolProductCategory
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolProductCategory schoolProductCategory){
        return toAjax(productCategoryService.insertSchoolProductCategory(schoolProductCategory));
    }

    /**
     * 修改产品分类信息
     * @param schoolProductCategory
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolProductCategory schoolProductCategory){
        return toAjax(productCategoryService.updateSchoolProductCategory(schoolProductCategory));
    }

    /**
     * 删除产品分类信息
     * @param ids
     * @return
     */
    @PostMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids){
        return toAjax(productCategoryService.deleteSchoolProductCategory(ids));
    }

    /**
     * 获取设备分类下拉框
     * @param
     * @return
     */
    @GetMapping("/getEquipmentType")
    public AjaxResult getEquipmentType(SchoolProductCategory schoolProductCategory){
        return AjaxResult.success(productCategoryService.getEquipmentType(schoolProductCategory));
    }

    /**
     * 获取管理员
     * @return
     */
    @GetMapping("/getAdmin")
    public AjaxResult getAdmin(SchoolProductCategory schoolProductCategory){
        return AjaxResult.success(productCategoryService.getAdmin(schoolProductCategory));
    }

    /**
     * 根据分类编码查询产品分类信息
     * @param code
     * @return
     */
    @GetMapping("/getEquipmentByCode/{code}")
    public AjaxResult getEquipmentByCode(@PathVariable("code") String code){
        return AjaxResult.success(productCategoryService.getEquipmentByCode(code));
    }
}
