package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.service.schoolEquipment.ICirculationService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;

/**
 * 设备借出归还
 */

@RestController
@RequestMapping("/circulation")
public class CirculationController extends BaseController {

    @Autowired
    private ICirculationService circulationService;

    /**
     * 查看设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolCirculationVo schoolCirculationVo){
        startPage();
        return getDataTable(circulationService.selectSchoolCirculationVoList(schoolCirculationVo));
    }

    /**
     * 查看设备借出归还详细信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(circulationService.selectSchoolCirculationVoById(id));
    }

    /**
     * 新增设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolCirculation schoolCirculation){
        return toAjax(circulationService.insertSchoolCirculation(schoolCirculation));
    }

    /**
     * 修改设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolCirculation schoolCirculation){
        return toAjax(circulationService.updateSchoolCirculation(schoolCirculation));
    }

    /**
     * 删除设备借出归还信息
     * @param ids
     * @return
     */
    @PostMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids){
        return toAjax(circulationService.deleteSchoolCirculationByIds(ids));
    }
}
