//I've got everything you need (for router management)! 我拥有你需要(处理路由问题)的一切！

//路由对象封装
export class Path_Destination {
  constructor(path, params = {}, query = {}) {
    this.path = path
    this.params = params
    this.query = query
  }
}

export class Name_Destination {
  constructor(name, params = {}, query = {}) {
    this.name = name
    this.params = params
    this.query = query
  }
}

//封装跳转路由的方法，不用写二道！
// RouterObj可以是完整的链接，也可以是路由对象，都可以直接跳转
export function jumpTo(RouterObj) {
  this.$router.push(RouterObj)
}

//封装回退路由清除面包屑的方法
//参数：skip=>跳过提示，直接回退
//参数：tipInfo=>提示内容
import store from "@/store"

export function closeCurrentTab(skip = false, tipInfo) {
  const routeBack = () => {
    store.commit('tagsView/DEL_VISITED_VIEW', this.$route)
    this.$router.go(-1);
  }
  if (skip) routeBack()
  else
    this.$confirm(tipInfo, '提示', {type: 'warning'}).then(routeBack)
}

//使用说明：
// 把它引入需要跳转路由的地方
//具体实例：

//一、导入
// import {
//   Path_Destination,
//   jumpTo,
// } from "@/utils/utilLibrary/routerBatch/routerBatch.js";
// export default{
//   /*****具体内容省略。。。******/


// methods:{
// 路由工具库模块
//   Path_Destination,
//   jumpTo,
// }
//   /*****具体内容省略。。。******/
// }

//二、使用
// <el-button @click="jumpTo(new Path_Destination('/rectifyNotice/theHeadCirculate'))">流转</el-button>
