import { isArray } from "@/utils/validate";

/**
 * @description 将班级数据处理为树形结构
 * @param data {gradeValue, classValue, id}
 * @param grades 字典数据-年级
 * @param classes 字典数据-班级
 * @return resultList []
 */
export function getTreeClass(data = [], grades = [], classes = []) {
  // 年级Map
  const gradeMap = new Map();
  // 返回结果
  const resultList = [];

  data.forEach(item => {
    const classList = gradeMap.get(item.gradeValue);
    const classItem = classes.find(res => Number(res.value) === item.classValue);
    if (classItem) {
      if (classList) {
        const index = classList.findIndex(res => res.value === item.classValue);
        if (index > -1) {
          classList[index].id = item.id;
        } else {
          classList.push({
            id: item.id,
            value: item.classValue,
            label: classItem.label
          });
        }
      } else {
        gradeMap.set(item.gradeValue, [{
          id: item.id,
          value: item.classValue,
          label: classItem.label
        }]);
      }
    }
  });
  for (let [key, variable] of gradeMap.entries()) {
    resultList.push({
      value: key,
      label: grades.find(res => Number(res.value) === key).label,
      children: [...variable]
    });
  }
  // console.log(resultList);
  return resultList;
}


// const data = [
//   { id: 1, gradeValue: 0, classValue: 0 },
//   { id: 2, gradeValue: 0, classValue: 1 },
//   { id: 3, gradeValue: 0, classValue: 2 },
//   { id: 4, gradeValue: 1, classValue: 0 },
//   { id: 5, gradeValue: 1, classValue: 1 },
//   { id: 9, gradeValue: 1, classValue: 1 },
//   { id: 6, gradeValue: 2, classValue: 0 },
//   { id: 7, gradeValue: 2, classValue: 1 },
//   { id: 8, gradeValue: 2, classValue: 2 },
// ]
//
// const grades = [
//   { label: '一年级', value: "0" },
//   { label: '二年级', value: "1" },
//   { label: '三年级', value: "2" },
// ]
//
// const classes = [
//   { label: '一班', value: "0" },
//   { label: '二班', value: "1" },
//   { label: '三班', value: "2" },
// ]
//
// getTreeClass(data, grades, classes);


/**
 * @description 获取树形下拉数据
 * @param data 树形结构数据
 * @param gradeTypes 类型：初中、高中、小学、幼儿园
 * @param grades 年级字典
 * */
export function handleTreeData(data = [], gradeTypes = [], grades = []) {
  const treeList = data[0] && data[0].children;
  if (isArray(treeList) && treeList.length > 0) {


    return treeList.map(schoolNode => {
      const value = schoolNode.label;
      const result = gradeTypes.find(gradeType => gradeType.value === value);
      schoolNode.label = result && result.label;
      isArray(schoolNode.children) && schoolNode.children.map(gradeNode => {
        const gradeLabel = grades.find(grade => grade.value === gradeNode.label);
        gradeNode.label = gradeLabel && gradeLabel.label;
        return gradeNode;
      })
      return schoolNode;
    })


  }
  return [];
}





/**
 * @description 获取第一个叶子节点
 * */
export function getFirstLeafNode(data = {}) {
  if (data.children && data.children.length > 0) {
    return getFirstLeafNode(data.children[0]);
  } else {
    return data;
  }
}
