import Layout from '@/layout';

export default [
  {
    path: '/teachAffair',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'gradeMemberList',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/affairGradeManage/gradeMemberList'),
        name: 'gradeMemberList',
        meta: {
          title: '级部成员'
        }
      }
    ]
  },

//教务管理--班级查看--评测
//   {
//     path: '/affairClassView/studentmanage',
//     component: Layout,
//     hidden: true,
//     permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
//     children: [
//       {
//         path: 'comprehensiveEvaluation',
//         component: () => import ('@/views/smartSchool/teachAffairAdministration/affairClassView/comprehensiveEvaluation'),
//         name: 'teachAffairComprehensiveEvaluation',
//         meta: {
//           title: '学生评测'
//         }
//       }
//     ]
//   },

  // 教务管理/班级管理/任课教师列表
  {
    path: '/jwClassManage',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'teacherLists',
        component: () => import('@/views/smartSchool/teachAffairAdministration/affairClassManage/teacherList'),
        name: 'teacherList',
        meta: {
          title: '任课教师'
        }
      }
    ]
  },

  //教务管理
  {
    path: '/teachAffairAdministration',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'parentsInfo',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/affairParentInformtion'),
        name: 'parentsInfo',
        meta: {
          title: '家长编辑'
        }
      },
      {
        path: 'studentTable',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/affairStudentManage/components/studentTable'),
        name: 'teachAffairStudentTable',
        meta: {
          title: '学籍表'
        }
      },
      {
        path: 'studentProve',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/affairStudentManage/components/studentProve'),
        name: 'StudentProve',
        meta: {
          title: '学籍证明'
        }
      },
      {
        path: 'alterCheck',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/alterManage/components/download.vue'),
        name: 'alterCheck',
        meta: {
          title: '异动审批表'
        }
      },
      {
        path: 'studentManage/parentInfo',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/affairStudentManage/components/parentInfo'),
        name: 'teachAffairParentInfo',
        meta: {
          title: '家长信息'
        }
      }
    ]
  },


  //教务管理--信息采集--详情
  {
    path: '/acquisition',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'dataView',
        component: () => import ('@/views/smartSchool/teachAffairAdministration/acquisition/components/detail'),
        name: 'TeachAffairAcquisitionDataView',
        meta: {
          title: '详情'
        }
      }
    ]
  },

  //调查问卷模块
  {
    path: '/teachAffairQuestion',
    component: Layout,
    hidden: true,
    permissions: ['question:child:check'],
    children: [
      {
        path: "content/:examId",
        component: () => import('@/views/smartSchool/teachAffairAdministration/questionnaireManagement/components/QuestionnaireContent'),
        name: 'TeachAffairQuestionnaireContent',
        meta: {
          title: '问卷内容'
        }
      },
      {
        path: 'result',
        component: () => import('@/views/smartSchool/teachAffairAdministration/questionnaireManagement/components/ActivityResult'),
        name: 'QuestionnaireResult',
        meta: {
          title: '问卷结果'
        }
      },
    ]
  },

  // 后勤管理/预算采购/资金使用明细 2023-08-16 DXS
  {
    path: '/logisticsManage',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'detailsofFundusage',
        component: () => import('@/views/smartSchool/logisticsManage/detailsofFundusage'),
        name: 'teacherList',
        meta: {
          title: '资金使用明细'
        }
      }
    ]
  },
]
