import Layout from "@/layout";

export default [
  // 校园简介编辑页面
  {
    path: "/schoolManage/schoolInfo",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "edit",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/introduce/schoolInfo/index.vue"
          ),
        name: "campusInfoEdit",
        meta: {
          title: "校园简介编辑",
        },
      },
    ],
  },
  // 学校通知，接收人列表页面
  {
    path: "/schoolManage/infoPush",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "receiveList",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/schoolNotice/infoPush/components/receiveList.vue"
          ),
        name: "schoolManage_receiveList",
        meta: {
          title: "接收人列表",
        },
      },
    ],
  },
  // 校历管理，详细条目查看
  {
    path: "/schoolManage/calendar",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "schoolCalendarDetail",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/calendarManagement/schoolCalendarDetail/index.vue"
          ),
        name: "schoolCalendarDetail",
        meta: {
          title: "校历明细",
        },
      },
    ],
  },
  // 值班管理，值班安排明细
  {
    path: "/schoolManage/dutyManage/dutyArrange",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/dutyManage/dutyArrange/index.vue"
          ),
        name: "dutyArrange",
        meta: {
          title: "值班安排明细",
        },
      },
    ],
  },

  // 值班管理，值班表
  {
    path: "/schoolManage/dutyManage/dutySchedule",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "",
        component: () =>
          import("@/views/smartSchool/schoolManage/dutyManage/dutySchedule"),
        name: "dutySchedule",
        meta: {
          title: "值班表",
        },
      },
    ],
  },

  // 学校消息推送
  {
    path: "/schoolManage/teacherMessage",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "",
        component: () => import("@/views/home/message/message.vue"),
        name: "teacherMessage",
        meta: {
          title: "学校消息推送",
        },
      },
    ],
  },
  // 冬夏时令---学校时刻明细
  {
    path: "/schoolManage",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "schoolMomentsDetail",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/schoolMoments/components/schoolMomentsDetail"
          ),
        name: "SchoolMomentsDetail",
        meta: {
          title: "学校时刻明细",
        },
      },
    ],
  },
  //人员分组
  {
    path: "/schoolManage/schoolNotice",
    component: Layout,
    hidden: true,
    permissions: ["system:role:edit"],
    children: [
      {
        path: "/personnelGrouping/authUser",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/schoolNotice/personnelGrouping/authUser.vue"
          ),
        name: "AuthUser",
        meta: {
          title: "分配成员",
          activeMenu:
            "/smartSchool/schoolManage/schoolNotice/personnelGrouping",
        },
      },
    ],
  },
  // 公文流转--公文流转查看
  {
    path: "/schoolManage",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "documentFlowView",
        component: () =>
          import(
            "@/views/smartSchool/schoolManage/documentFlow/documentFlowView.vue"
          ),
        name: "documentFlowView",
        meta: {
          title: "公文流转查看",
        },
      },
    ],
  },
];
